/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.lib.lib.util.FluidLib;
import de.teamlapen.vampirism.api.entity.IBiteableEntity;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.items.StakeItem;
import de.teamlapen.vampirism.mixin.accessor.LivingEntityAccessor;
import de.teamlapen.vampirism.modcompat.IMCHandler;
import de.teamlapen.vampirism.util.Helper;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class VampirismHUDOverlay {
    private final Minecraft mc;
    protected static final ResourceLocation CROSSHAIR_SPRITE = VResourceLocation.mc("hud/crosshair");
    protected static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE = VResourceLocation.mc("hud/crosshair_attack_indicator_full");
    protected static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE = VResourceLocation.mc("hud/crosshair_attack_indicator_background");
    protected static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE = VResourceLocation.mc("hud/crosshair_attack_indicator_progress");
    public static final ResourceLocation FANG_SPRITE = VResourceLocation.mod("fang/fang");
    public static final ResourceLocation PROGRESS_BACKGROUND_SPRITE = VResourceLocation.mod("fang/progress_background");
    public static final ResourceLocation PROGRESS_FOREGROUND_SPRITE = VResourceLocation.mod("fang/progress_foreground");
    private int screenColor = 0;
    private int screenPercentage = 0;
    private int renderFullTick = 0;
    private int rederFullOn;
    private int renderFullOff;
    private int renderFullColor;
    private boolean addTempPoison;
    private MobEffectInstance addedTempPoison;

    public VampirismHUDOverlay(Minecraft mc) {
        this.mc = mc;
    }

    public void makeRenderFullColor(int on, int off, int color) {
        this.rederFullOn = on;
        this.renderFullOff = off;
        this.renderFullTick = on + off;
        if ((color >> 24 & 0xFF) == 0) {
            color |= 0xFF000000;
        }
        this.renderFullColor = color;
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Pre event) {
        if (this.mc.player == null || !this.mc.player.isAlive()) {
            this.renderFullTick = 0;
            this.screenPercentage = 0;
            return;
        }
        if (this.renderFullTick > 0) {
            this.screenColor = this.renderFullColor;
            this.screenPercentage = this.renderFullTick > this.renderFullOff ? (int)(100.0f * (1.0f - (float)(this.renderFullTick - this.renderFullOff) / (float)this.rederFullOn)) : (int)((float)(100 * this.renderFullTick) / (float)this.renderFullOff);
            --this.renderFullTick;
        }
    }

    @SubscribeEvent
    public void onRenderCrosshair(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderGuiLayerEvent.Pre event) {
        float progress;
        if (event.getName() != VanillaGuiLayers.CROSSHAIR || this.mc.player == null || !this.mc.player.isAlive()) {
            return;
        }
        HitResult p = Minecraft.getInstance().hitResult;
        if (p != null && p.getType() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)p).getEntity();
            if (!entity.isInvisible()) {
                VampirismPlayerAttributes atts = VampirismPlayerAttributes.get((Player)this.mc.player);
                if (atts.vampireLevel > 0 && !this.mc.player.isSpectator() && !atts.getVampSpecial().bat) {
                    VampirePlayer vampire = VampirePlayer.get((Player)this.mc.player);
                    Optional<Object> biteableOpt = Optional.empty();
                    if (entity instanceof IBiteableEntity) {
                        biteableOpt = Optional.of((IBiteableEntity)entity);
                    } else if (entity instanceof PathfinderMob && entity.isAlive()) {
                        biteableOpt = ExtendedCreature.getSafe(entity);
                    } else if (entity instanceof Player) {
                        biteableOpt = Optional.of(VampirePlayer.get((Player)entity));
                    }
                    biteableOpt.filter(iBiteableEntity -> iBiteableEntity.canBeBitten(vampire)).ifPresent(biteable -> {
                        int color = 0xFF0000;
                        if (entity instanceof IHunterMob || ExtendedCreature.getSafe(entity).map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse(false).booleanValue()) {
                            color = 626722;
                        }
                        this.renderBloodFangs(event.getGuiGraphics(), this.mc.getWindow().getGuiScaledWidth(), this.mc.getWindow().getGuiScaledHeight(), Mth.clamp((float)biteable.getBloodLevelRelative(), (float)0.2f, (float)1.0f), color);
                        event.setCanceled(true);
                    });
                }
                if (atts.hunterLevel > 0 && !this.mc.player.isSpectator() && this.mc.player.getMainHandItem().getItem() == ModItems.STAKE.get() && entity instanceof LivingEntity && entity instanceof IVampireMob && StakeItem.canKillInstant((LivingEntity)entity, (LivingEntity)this.mc.player) && ((LivingEntity)entity).getHealth() > 0.0f) {
                    this.renderStakeInstantKill(event.getGuiGraphics(), this.mc.getWindow().getGuiScaledWidth(), this.mc.getWindow().getGuiScaledHeight());
                    event.setCanceled(true);
                }
            }
        } else if (p != null && p.getType() == HitResult.Type.BLOCK) {
            BlockEntity tile;
            BlockState block = Minecraft.getInstance().level.getBlockState(((BlockHitResult)p).getBlockPos());
            if (ModBlocks.BLOOD_CONTAINER.get() == block.getBlock() && VampirePlayer.get((Player)this.mc.player).wantsBlood() && (tile = Minecraft.getInstance().level.getBlockEntity(((BlockHitResult)p).getBlockPos())) != null) {
                Optional.ofNullable((IFluidHandler)Minecraft.getInstance().level.getCapability(Capabilities.FluidHandler.BLOCK, ((BlockHitResult)p).getBlockPos(), block, tile, null)).ifPresent(handler -> {
                    if (FluidLib.getFluidAmount(handler, (Fluid)ModFluids.BLOOD.get()) > 0) {
                        this.renderBloodFangs(event.getGuiGraphics(), this.mc.getWindow().getGuiScaledWidth(), this.mc.getWindow().getGuiScaledHeight(), 1.0f, 0xFF0000);
                        event.setCanceled(true);
                    }
                });
            }
        }
        Options gamesettings = this.mc.options;
        if (gamesettings.getCameraType().isFirstPerson() && this.mc.gameMode.getPlayerMode() != GameType.SPECTATOR && (progress = VampirePlayer.get((Player)this.mc.player).getFeedProgress()) > 0.0f) {
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            if (progress <= 1.0f) {
                int x = this.mc.getWindow().getGuiScaledWidth() / 2 - 8;
                int y = this.mc.getWindow().getGuiScaledHeight() / 2 - 7 + 16;
                int l = (int)(progress * 14.0f) + 2;
                event.getGuiGraphics().blitSprite(PROGRESS_BACKGROUND_SPRITE, x, y, 16, 2);
                event.getGuiGraphics().blitSprite(PROGRESS_FOREGROUND_SPRITE, 16, 2, 0, 0, x, y, l, 2);
            }
        }
    }

    @SubscribeEvent
    public void onRenderFoodBar(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderGuiLayerEvent.Pre event) {
        if (this.mc.player == null || !this.mc.player.isAlive() || !Helper.isVampire((Player)this.mc.player)) {
            return;
        }
        if (event.getName() == VanillaGuiLayers.FOOD_LEVEL && !IMCHandler.requestedToDisableBloodbar && this.mc.gameMode.hasExperience()) {
            event.setCanceled(true);
        }
        if (event.getName().equals((Object)VanillaGuiLayers.AIR_LEVEL)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderGameOverlay(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderGuiEvent.Pre event) {
        if (this.screenPercentage > 0 && ((Boolean)VampirismConfig.CLIENT.renderScreenOverlay.get()).booleanValue()) {
            PoseStack stack = event.getGuiGraphics().pose();
            stack.pushPose();
            int w = event.getGuiGraphics().guiWidth();
            int h = event.getGuiGraphics().guiHeight();
            float r = (float)(this.screenColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(this.screenColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(this.screenColor & 0xFF) / 255.0f;
            float a = (float)this.screenPercentage / 100.0f * (float)(this.screenColor >> 24 & 0xFF) / 255.0f;
            Matrix4f matrix = stack.last().pose();
            VertexConsumer buffer = event.getGuiGraphics().bufferSource().getBuffer(RenderType.guiOverlay());
            buffer.addVertex(matrix, 0.0f, (float)h, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, (float)w, (float)h, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, (float)w, 0.0f, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(r, g, b, a);
            event.getGuiGraphics().flush();
            stack.popPose();
        }
    }

    @SubscribeEvent
    public void onRenderHealthBarPost(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderGuiLayerEvent.Post event) {
        if (event.getName() != VanillaGuiLayers.PLAYER_HEALTH) {
            return;
        }
        if (this.addTempPoison) {
            ((LivingEntityAccessor)this.mc.player).getActiveEffects().remove(MobEffects.POISON);
        }
    }

    @SubscribeEvent
    public void onRenderHealthBarPre(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderGuiLayerEvent.Pre event) {
        if (event.getName() != VanillaGuiLayers.PLAYER_HEALTH) {
            return;
        }
        boolean bl = this.addTempPoison = this.mc.player.hasEffect(ModEffects.POISON) && !((LivingEntityAccessor)this.mc.player).getActiveEffects().containsKey(MobEffects.POISON);
        if (this.addTempPoison) {
            if (this.addedTempPoison == null) {
                this.addedTempPoison = new MobEffectInstance(MobEffects.POISON, 100);
            }
            ((LivingEntityAccessor)this.mc.player).getActiveEffects().put((Holder<MobEffect>)MobEffects.POISON, this.addedTempPoison);
        }
    }

    private void renderBloodFangs(@NotNull GuiGraphics graphics, int width, int height, float perc, int color) {
        float r = (float)((color & 0xFF0000) >> 16) / 256.0f;
        float g = (float)((color & 0xFF00) >> 8) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        int left = width / 2 - 8;
        int top = height / 2 - 4;
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, 0.7f);
        graphics.blitSprite(FANG_SPRITE, left, top, 16, 10);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)0.8f);
        int percHeight = (int)(10.0f * perc);
        graphics.blitSprite(FANG_SPRITE, 16, 10, 0, 10 - percHeight, left, top + (10 - percHeight), 16, percHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void renderStakeInstantKill(@NotNull GuiGraphics graphics, int width, int height) {
        RenderSystem.enableBlend();
        if (this.mc.options.getCameraType().isFirstPerson() && this.mc.gameMode.getPlayerMode() != GameType.SPECTATOR) {
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            graphics.setColor(0.6171875f, 0.0f, 0.0f, 1.0f);
            graphics.blitSprite(CROSSHAIR_SPRITE, (graphics.guiWidth() - 15) / 2, (graphics.guiHeight() - 15) / 2, 15, 15);
            float f = this.mc.player.getAttackStrengthScale(0.0f);
            boolean flag = false;
            if (this.mc.crosshairPickEntity != null && this.mc.crosshairPickEntity instanceof LivingEntity && f >= 1.0f) {
                flag = this.mc.player.getCurrentItemAttackStrengthDelay() > 5.0f;
                flag &= this.mc.crosshairPickEntity.isAlive();
            }
            int j = graphics.guiHeight() / 2 - 7 + 16;
            int k = graphics.guiWidth() / 2 - 8;
            if (flag) {
                graphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE, k, j, 16, 16);
            } else if (f < 1.0f) {
                int l = (int)(f * 17.0f);
                graphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE, k, j, 16, 4);
                graphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE, 16, 4, 0, 0, k, j, l, 4);
            }
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.defaultBlendFunc();
        }
        RenderSystem.disableBlend();
    }
}

