/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.overlay;

import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.client.gui.overlay.TextureOverlay;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SunOverlay
extends TextureOverlay {
    public static final ResourceLocation SUN_TEXTURE = VResourceLocation.mod("textures/misc/sun.png");

    public void render(@NotNull GuiGraphics graphics, @NotNull DeltaTracker deltaTracker) {
        if (this.mc.player != null && ((Boolean)VampirismConfig.CLIENT.enableSunOverlayRendering.get()).booleanValue()) {
            LocalPlayer player = this.mc.player;
            VampirePlayer vampire = VampirePlayer.get((Player)player);
            MobEffectInstance effect = player.getEffect(ModEffects.SUNSCREEN);
            float progress = Math.clamp((float)vampire.getTicksInSun() / 50.0f, 0.0f, 1.0f);
            if (progress > 0.0f && (effect == null || effect.getAmplifier() < 5)) {
                if (player.getAbilities().instabuild || effect != null && effect.getAmplifier() >= 3) {
                    progress = Math.min(0.5f, progress);
                }
                graphics.pose().pushPose();
                this.scaleBy(progress, 0.2f, 2.0f, 1.0f, graphics);
                this.renderTextureOverlay(graphics, SUN_TEXTURE, 1.0f);
                graphics.pose().popPose();
            }
        }
    }
}

