/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blocks.CandleStickBlock;
import de.teamlapen.vampirism.core.ModItems;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class WallCandleStickBlock
extends CandleStickBlock {
    public static final MapCodec<WallCandleStickBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> WallCandleStickBlock.candleStickParts(inst).apply((Applicative)inst, WallCandleStickBlock::new));
    private static final Map<Direction, Iterable<Vec3>> PARTICLE_OFFSET = new EnumMap<Direction, Iterable<Vec3>>(Direction.class){
        {
            this.put(Direction.NORTH, ImmutableList.of((Object)new Vec3(0.5, 0.86, 0.75)));
            this.put(Direction.WEST, ImmutableList.of((Object)new Vec3(0.75, 0.86, 0.5)));
            this.put(Direction.SOUTH, ImmutableList.of((Object)new Vec3(0.5, 0.86, 0.25)));
            this.put(Direction.EAST, ImmutableList.of((Object)new Vec3(0.25, 0.86, 0.5)));
        }
    };
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class){
        {
            this.put(Direction.NORTH, UtilLib.rotateShape(WallCandleStickBlock.makeShape(), UtilLib.RotationAmount.HUNDRED_EIGHTY));
            this.put(Direction.WEST, UtilLib.rotateShape(WallCandleStickBlock.makeShape(), UtilLib.RotationAmount.NINETY));
            this.put(Direction.SOUTH, WallCandleStickBlock.makeShape());
            this.put(Direction.EAST, UtilLib.rotateShape(WallCandleStickBlock.makeShape(), UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY));
        }
    };
    private static final Map<Direction, VoxelShape> SHAPES_WITH_CANDLE = new EnumMap<Direction, VoxelShape>(Direction.class){
        {
            this.put(Direction.NORTH, UtilLib.rotateShape(WallCandleStickBlock.makeShapeWithCandle(), UtilLib.RotationAmount.HUNDRED_EIGHTY));
            this.put(Direction.WEST, UtilLib.rotateShape(WallCandleStickBlock.makeShapeWithCandle(), UtilLib.RotationAmount.NINETY));
            this.put(Direction.SOUTH, WallCandleStickBlock.makeShapeWithCandle());
            this.put(Direction.EAST, UtilLib.rotateShape(WallCandleStickBlock.makeShapeWithCandle(), UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY));
        }
    };
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    private WallCandleStickBlock(Block emptyBlock, Item candle, BlockBehaviour.Properties pProperties) {
        this(() -> emptyBlock, () -> candle, pProperties);
    }

    public WallCandleStickBlock(@Nullable Supplier<? extends Block> emptyBlock, @NotNull Supplier<Item> candle, BlockBehaviour.Properties pProperties) {
        super(emptyBlock, candle, pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected BlockState getFilledState(BlockState sourceState, Block block) {
        return (BlockState)super.getFilledState(sourceState, block).setValue((Property)FACING, (Comparable)((Direction)sourceState.getValue((Property)FACING)));
    }

    @Override
    protected BlockState getEmptyState(BlockState sourceState, Block block) {
        return (BlockState)super.getEmptyState(sourceState, block).setValue((Property)FACING, (Comparable)((Direction)sourceState.getValue((Property)FACING)));
    }

    @Override
    public boolean canSurvive(@NotNull BlockState pState, @NotNull LevelReader pLevel, @NotNull BlockPos pPos) {
        return pLevel.getBlockState(pPos.relative(((Direction)pState.getValue((Property)FACING)).getOpposite())).isSolid();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction[] adirection;
        BlockState blockstate = this.defaultBlockState();
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        Level levelreader = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        for (Direction direction : adirection = pContext.getNearestLookingDirections()) {
            Direction direction1;
            if (!direction.getAxis().isHorizontal() || !(blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)(direction1 = direction.getOpposite()))).canSurvive((LevelReader)levelreader, blockpos)) continue;
            return (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        }
        return null;
    }

    @Override
    @NotNull
    public BlockState updateShape(@NotNull BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        return pFacing.getOpposite() == pState.getValue((Property)FACING) && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @NotNull
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pMirror.mirror((Direction)pState.getValue((Property)FACING)));
    }

    @Override
    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)pBuilder.add(new Property[]{FACING}));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.isEmpty() ? SHAPES.get(pState.getValue((Property)FACING)) : SHAPES_WITH_CANDLE.get(pState.getValue((Property)FACING));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ((StandingAndWallBlockItem)ModItems.CANDLE_STICK.get()).getDefaultInstance();
    }

    @NotNull
    protected MapCodec<? extends AbstractCandleBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected Iterable<Vec3> getParticleOffsets(@NotNull BlockState pState) {
        return PARTICLE_OFFSET.get(pState.getValue((Property)FACING));
    }

    private static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.0, (double)0.625, (double)0.25, (double)0.0625));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.0625, (double)0.0625, (double)0.5625, (double)0.1875, (double)0.3125));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.0625, (double)0.1875, (double)0.5625, (double)0.25, (double)0.3125));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.25, (double)0.125, (double)0.625, (double)0.375, (double)0.375));
        return shape;
    }

    private static VoxelShape makeShapeWithCandle() {
        VoxelShape shape = WallCandleStickBlock.makeShape();
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.375, (double)0.1875, (double)0.5625, (double)0.75, (double)0.3125));
        return shape;
    }
}

