/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blocks.VampirismBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampirismSplitBlock
extends VampirismBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);
    private final VoxelShape NORTH1;
    @NotNull
    private final VoxelShape EAST1;
    @NotNull
    private final VoxelShape SOUTH1;
    @NotNull
    private final VoxelShape WEST1;
    private final VoxelShape NORTH2;
    @NotNull
    private final VoxelShape EAST2;
    @NotNull
    private final VoxelShape SOUTH2;
    @NotNull
    private final VoxelShape WEST2;
    private final boolean vertical;

    public VampirismSplitBlock(@NotNull BlockBehaviour.Properties properties, VoxelShape mainShape, VoxelShape subShape, boolean vertical) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)Part.MAIN)));
        this.NORTH1 = mainShape;
        this.EAST1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.NINETY);
        this.SOUTH1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.HUNDRED_EIGHTY);
        this.WEST1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
        this.NORTH2 = subShape;
        this.EAST2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.NINETY);
        this.SOUTH2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.HUNDRED_EIGHTY);
        this.WEST2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
        this.vertical = vertical;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState p_149645_1_) {
        return p_149645_1_.getValue(PART) == Part.MAIN ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        boolean main = state.getValue(PART) == Part.MAIN;
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> {
                if (main) {
                    yield this.NORTH1;
                }
                yield this.NORTH2;
            }
            case Direction.EAST -> {
                if (main) {
                    yield this.EAST1;
                }
                yield this.EAST2;
            }
            case Direction.SOUTH -> {
                if (main) {
                    yield this.SOUTH1;
                }
                yield this.SOUTH2;
            }
            case Direction.WEST -> {
                if (main) {
                    yield this.WEST1;
                }
                yield this.WEST2;
            }
            default -> this.NORTH1;
        };
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Direction enumfacing = context.getHorizontalDirection();
        BlockPos blockpos = context.getClickedPos();
        BlockPos blockpos1 = blockpos.relative(this.vertical ? Direction.UP : enumfacing);
        return context.getLevel().getBlockState(blockpos1).canBeReplaced(context) ? (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)enumfacing) : null;
    }

    protected boolean isPathfindable(BlockState p_60475_, PathComputationType p_60478_) {
        return false;
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState playerWillDestroy(@NotNull Level world, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull Player player) {
        BlockPos blockpos;
        BlockState otherState;
        Part part;
        if (!world.isClientSide && player.isCreative() && (part = (Part)((Object)blockState.getValue(PART))) == Part.SUB && (otherState = world.getBlockState(blockpos = blockPos.relative(this.getOtherBlockDirection(blockState)))).getBlock() == this && otherState.getValue(PART) == Part.MAIN) {
            world.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 35);
            world.levelEvent(player, 2001, blockpos, Block.getId((BlockState)otherState));
        }
        return super.playerWillDestroy(world, blockPos, blockState, player);
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, @NotNull Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (!world.isClientSide) {
            BlockPos blockpos = pos.relative(this.getOtherBlockDirection(state));
            BlockState otherState = (BlockState)state.setValue(PART, (Comparable)((Object)Part.SUB));
            if (!this.vertical) {
                otherState = (BlockState)otherState.setValue((Property)FACING, (Comparable)((Direction)otherState.getValue((Property)FACING)).getOpposite());
            }
            world.setBlock(blockpos, otherState, 3);
            world.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)world, pos, 3);
        }
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing == this.getOtherBlockDirection(stateIn)) {
            return facingState.getBlock() == this && facingState.getValue(PART) != stateIn.getValue(PART) ? this.updateFromOther(stateIn, facingState) : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART});
    }

    @NotNull
    protected Direction getOtherBlockDirection(@NotNull BlockState blockState) {
        if (this.vertical) {
            return blockState.getValue(PART) == Part.MAIN ? Direction.UP : Direction.DOWN;
        }
        return (Direction)blockState.getValue((Property)FACING);
    }

    protected BlockState updateFromOther(BlockState thisState, BlockState otherState) {
        return thisState;
    }

    public static enum Part implements StringRepresentable
    {
        MAIN("main"),
        SUB("sub");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

