/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.mojang.serialization.MapCodec;
import de.teamlapen.vampirism.blockentity.VampireBeaconBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampireBeaconBlock
extends VampirismBlockContainer
implements BeaconBeamBlock {
    public static final MapCodec<VampireBeaconBlock> CODEC = VampireBeaconBlock.simpleCodec(VampireBeaconBlock::new);

    public VampireBeaconBlock(@NotNull BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public DyeColor getColor() {
        return DyeColor.RED;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new VampireBeaconBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return VampireBeaconBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModTiles.VAMPIRE_BEACON.get()), VampireBeaconBlockEntity::tick);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull BlockHitResult pHit) {
        if (!pLevel.isClientSide && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            serverPlayer.awardStat((ResourceLocation)ModStats.INTERACT_WITH_ANCIENT_BEACON.get());
            if (Helper.isHunter((Player)serverPlayer)) {
                BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
                if (blockEntity instanceof VampireBeaconBlockEntity) {
                    VampireBeaconBlockEntity blockentity = (VampireBeaconBlockEntity)blockEntity;
                    pPlayer.openMenu((MenuProvider)blockentity);
                }
            } else {
                pPlayer.displayClientMessage((Component)Component.translatable((String)"text.vampirism.unfamiliar"), true);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    public void setPlacedBy(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockEntity;
        if (pStack.has(DataComponents.CUSTOM_NAME) && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof VampireBeaconBlockEntity) {
            VampireBeaconBlockEntity blockEntity2 = (VampireBeaconBlockEntity)blockEntity;
            blockEntity2.setCustomName(pStack.getHoverName());
        }
    }
}

