/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.mojang.serialization.MapCodec;
import de.teamlapen.vampirism.blockentity.MotherTrophyBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotherTrophyBlock
extends BaseEntityBlock {
    public static final MapCodec<MotherTrophyBlock> CODEC = MotherTrophyBlock.simpleCodec(MotherTrophyBlock::new);
    public static final int MAX = RotationSegment.getMaxSegmentIndex();
    private static final int ROTATIONS = MAX + 1;
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    private static final VoxelShape SHAPE = MotherTrophyBlock.makeShape();

    public MotherTrophyBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new MotherTrophyBlockEntity(pPos, pState);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    @NotNull
    public VoxelShape getOcclusionShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        return Shapes.empty();
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)pContext.getRotation())));
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState pState, @NotNull Rotation pRotation) {
        return (BlockState)pState.setValue((Property)ROTATION, (Comparable)Integer.valueOf(pRotation.rotate(((Integer)pState.getValue((Property)ROTATION)).intValue(), ROTATIONS)));
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState pState, @NotNull Mirror pMirror) {
        return (BlockState)pState.setValue((Property)ROTATION, (Comparable)Integer.valueOf(pMirror.mirror(((Integer)pState.getValue((Property)ROTATION)).intValue(), ROTATIONS)));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{ROTATION});
    }

    @NotNull
    private static VoxelShape makeShape() {
        return Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.75, (double)0.625);
    }
}

