/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blockentity.GarlicDiffuserBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GarlicDiffuserBlock
extends VampirismBlockContainer {
    public static final MapCodec<GarlicDiffuserBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)StringRepresentable.fromEnum(Type::values).fieldOf("type").forGetter(p -> p.type), (App)GarlicDiffuserBlock.propertiesCodec()).apply((Applicative)inst, GarlicDiffuserBlock::new));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape shape = GarlicDiffuserBlock.makeShape();
    private final Type type;

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
        VoxelShape b = Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
        return Shapes.or((VoxelShape)a, (VoxelShape)b);
    }

    public GarlicDiffuserBlock(Type type) {
        this(type, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(40.0f, 1200.0f).sound(SoundType.STONE).noOcclusion());
    }

    public GarlicDiffuserBlock(Type type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag advanced) {
        if (this.type == Type.WEAK || this.type == Type.IMPROVED) {
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + "." + this.type.getSerializedName())).withStyle(ChatFormatting.AQUA));
        }
        tooltip.add((Component)Component.translatable((String)"block.vampirism.garlic_diffuser.tooltip1").withStyle(ChatFormatting.GRAY));
        int c = VampirismConfig.BALANCE.hsGarlicDiffuserEnhancedDist == null ? 1 : 1 + 2 * (this.type == Type.IMPROVED ? (Integer)VampirismConfig.BALANCE.hsGarlicDiffuserEnhancedDist.get() : (this.type == Type.WEAK ? (Integer)VampirismConfig.BALANCE.hsGarlicDiffuserWeakDist.get() : (Integer)VampirismConfig.BALANCE.hsGarlicDiffuserNormalDist.get()));
        tooltip.add((Component)Component.translatable((String)"block.vampirism.garlic_diffuser.tooltip2", (Object[])new Object[]{c, c}).withStyle(ChatFormatting.GRAY));
    }

    public void attack(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player playerIn) {
        GarlicDiffuserBlockEntity tile = this.getTile((BlockGetter)worldIn, pos);
        if (tile != null) {
            tile.onTouched(playerIn);
        }
    }

    @NotNull
    public String getDescriptionId() {
        return "block.vampirism.garlic_diffuser";
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return shape;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        GarlicDiffuserBlockEntity tile = new GarlicDiffuserBlockEntity(pos, state);
        tile.setType(this.type);
        tile.initiateBootTimer();
        return tile;
    }

    public void playerDestroy(@NotNull Level worldIn, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity te, @NotNull ItemStack stack) {
        super.playerDestroy(worldIn, player, pos, state, te, stack);
        if (te instanceof GarlicDiffuserBlockEntity) {
            ((GarlicDiffuserBlockEntity)te).onTouched(player);
        }
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, @NotNull Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!stack.isEmpty() && ModItems.PURIFIED_GARLIC.get() == stack.getItem()) {
            if (!world.isClientSide) {
                player.awardStat((ResourceLocation)ModStats.INTERACT_WITH_GARLIC_DIFFUSER.get());
                GarlicDiffuserBlockEntity t = this.getTile((BlockGetter)world, pos);
                if (t != null) {
                    if (t.getFuelTime() > 0) {
                        player.sendSystemMessage((Component)Component.translatable((String)"block.vampirism.garlic_diffuser.already_fueled"));
                    } else {
                        t.onFueled();
                        if (!player.isCreative()) {
                            stack.shrink(1);
                        }
                        player.sendSystemMessage((Component)Component.translatable((String)"block.vampirism.garlic_diffuser.successfully_fueled"));
                    }
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        GarlicDiffuserBlockEntity t;
        if (world.isClientSide && (t = this.getTile((BlockGetter)world, pos)) != null) {
            VampirismMod.proxy.displayGarlicBeaconScreen(t, (Component)this.getName());
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    private GarlicDiffuserBlockEntity getTile(@NotNull BlockGetter world, @NotNull BlockPos pos) {
        BlockEntity t = world.getBlockEntity(pos);
        if (t instanceof GarlicDiffuserBlockEntity) {
            return (GarlicDiffuserBlockEntity)t;
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return GarlicDiffuserBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModTiles.GARLIC_DIFFUSER.get()), GarlicDiffuserBlockEntity::tick);
    }

    public static enum Type implements StringRepresentable
    {
        NORMAL("normal"),
        IMPROVED("improved"),
        WEAK("weak");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

