/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import de.teamlapen.vampirism.blocks.CursedBarkBlock;
import de.teamlapen.vampirism.blocks.CursedSpruceBlock;
import de.teamlapen.vampirism.util.Helper;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectCursedBarkBlock
extends CursedBarkBlock {
    public static final EnumProperty<Type> UP_TYPE = EnumProperty.create((String)"up_type", Type.class);
    public static final EnumProperty<Type> DOWN_TYPE = EnumProperty.create((String)"down_type", Type.class);
    public static final EnumProperty<Type> NORTH_TYPE = EnumProperty.create((String)"north_type", Type.class);
    public static final EnumProperty<Type> SOUTH_TYPE = EnumProperty.create((String)"south_type", Type.class);
    public static final EnumProperty<Type> WEST_TYPE = EnumProperty.create((String)"west_type", Type.class);
    public static final EnumProperty<Type> EAST_TYPE = EnumProperty.create((String)"east_type", Type.class);
    public static final BiMap<Direction, EnumProperty<Type>> SIDE_MAP = ImmutableBiMap.builder().put((Object)Direction.UP, UP_TYPE).put((Object)Direction.DOWN, DOWN_TYPE).put((Object)Direction.EAST, EAST_TYPE).put((Object)Direction.WEST, WEST_TYPE).put((Object)Direction.NORTH, NORTH_TYPE).put((Object)Direction.SOUTH, SOUTH_TYPE).build();

    public DirectCursedBarkBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(UP_TYPE, (Comparable)((Object)Type.NONE))).setValue(DOWN_TYPE, (Comparable)((Object)Type.NONE))).setValue(EAST_TYPE, (Comparable)((Object)Type.NONE))).setValue(WEST_TYPE, (Comparable)((Object)Type.NONE))).setValue(NORTH_TYPE, (Comparable)((Object)Type.NONE))).setValue(SOUTH_TYPE, (Comparable)((Object)Type.NONE)));
    }

    public void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (Helper.isVampire(entity) || entity instanceof Player && ((Player)entity).getAbilities().invulnerable) {
            return;
        }
        BlockPos targetPos = pos;
        for (Map.Entry entry : SIDE_MAP.entrySet()) {
            if (state.getValue((Property)entry.getValue()) == Type.NONE) continue;
            targetPos = targetPos.relative((Direction)entry.getKey());
        }
        this.moveEntityTo(level, entity, targetPos);
    }

    private boolean canAttachTo(@NotNull BlockGetter blockReader, @NotNull BlockPos pos, @NotNull Direction direction) {
        CursedSpruceBlock cursedSpruce;
        BlockState blockstate = blockReader.getBlockState(pos);
        Block block = blockstate.getBlock();
        return block instanceof CursedSpruceBlock && !(cursedSpruce = (CursedSpruceBlock)block).isCured();
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader worldReader, @NotNull BlockPos blockPos) {
        for (Map.Entry entry : SIDE_MAP.entrySet()) {
            if (state.getValue((Property)entry.getValue()) == Type.NONE || !this.canAttachTo((BlockGetter)worldReader, blockPos.relative((Direction)entry.getKey()), ((Direction)entry.getKey()).getOpposite())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState blockState, @NotNull Direction direction, @NotNull BlockState otherState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos otherPos) {
        EnumProperty property = (EnumProperty)SIDE_MAP.get((Object)direction);
        if (blockState.getValue((Property)property) != Type.NONE) {
            if (!this.canAttachTo((BlockGetter)level, otherPos, direction.getOpposite())) {
                BlockState state = (BlockState)blockState.setValue((Property)property, (Comparable)((Object)Type.NONE));
                if (!DirectCursedBarkBlock.anySideAvailable(state)) {
                    state = Blocks.AIR.defaultBlockState();
                }
                return state;
            }
        } else if (!DirectCursedBarkBlock.anySideAvailable(blockState)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(blockState, direction, otherState, level, pos, otherPos);
    }

    private static boolean anySideAvailable(BlockState state) {
        return SIDE_MAP.values().stream().anyMatch(property -> state.getValue((Property)property) != Type.NONE);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Direction direction = context.getNearestLookingDirection();
        return (BlockState)this.defaultBlockState().setValue((Property)SIDE_MAP.get((Object)direction), (Comparable)((Object)Type.VERTICAL));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(SIDE_MAP.values().toArray(new Property[0]));
    }

    public static enum Type implements StringRepresentable
    {
        VERTICAL,
        HORIZONTAL,
        NONE;


        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

