/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.api.blocks.HolyWaterEffectConsumer;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.blocks.DiagonalCursedBarkBlock;
import de.teamlapen.vampirism.blocks.DirectCursedBarkBlock;
import de.teamlapen.vampirism.blocks.LogBlock;
import de.teamlapen.vampirism.blocks.StrippableLogBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public class CursedSpruceBlock
extends StrippableLogBlock
implements HolyWaterEffectConsumer {
    private final Supplier<? extends CursedSpruceBlock> curedBlockSupplier;

    public CursedSpruceBlock(@NotNull Supplier<? extends LogBlock> strippedBlock, Supplier<? extends CursedSpruceBlock> curedBlockSupplier) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.CRIMSON_HYPHAE).strength(2.0f).sound(SoundType.WOOD).randomTicks().ignitedByLava(), strippedBlock);
        this.curedBlockSupplier = curedBlockSupplier;
    }

    public CursedSpruceBlock(@NotNull Supplier<? extends LogBlock> strippedBlock) {
        this(strippedBlock, null);
    }

    public boolean isCured() {
        return this.curedBlockSupplier == null;
    }

    @Override
    public void onHolyWaterEffect(Level level, BlockState state, BlockPos pos, ItemStack holyWaterStack, IItemWithTier.TIER tier) {
        if (this.curedBlockSupplier != null) {
            BlockState newState = this.curedBlockSupplier.get().defaultBlockState();
            state.getValues().keySet().forEach(property -> newState.setValue(property, state.getValue(property)));
            level.setBlockAndUpdate(pos, newState);
        }
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        DirectCursedBarkBlock.Type type = null;
        List directions = Arrays.stream(Direction.values()).collect(Collectors.toList());
        Direction direction = null;
        if (state.getBlock() == ModBlocks.CURSED_SPRUCE_LOG.get()) {
            switch ((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS)) {
                case X: {
                    directions.remove(Direction.WEST);
                    directions.remove(Direction.EAST);
                    direction = (Direction)directions.get(random.nextInt(directions.size()));
                    type = DirectCursedBarkBlock.Type.HORIZONTAL;
                    break;
                }
                case Y: {
                    directions.remove(Direction.UP);
                    directions.remove(Direction.DOWN);
                    direction = (Direction)directions.get(random.nextInt(directions.size()));
                    type = DirectCursedBarkBlock.Type.VERTICAL;
                    break;
                }
                case Z: {
                    directions.remove(Direction.NORTH);
                    directions.remove(Direction.SOUTH);
                    direction = (Direction)directions.get(random.nextInt(directions.size()));
                    type = direction.getAxis() == Direction.Axis.X ? DirectCursedBarkBlock.Type.HORIZONTAL : DirectCursedBarkBlock.Type.VERTICAL;
                }
            }
        } else if (state.getBlock() == ModBlocks.CURSED_SPRUCE_WOOD.get()) {
            direction = (Direction)directions.get(random.nextInt(directions.size()));
            switch ((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS)) {
                case X: {
                    if (direction.getAxis() == Direction.Axis.X) {
                        type = DirectCursedBarkBlock.Type.VERTICAL;
                        break;
                    }
                    type = DirectCursedBarkBlock.Type.HORIZONTAL;
                    break;
                }
                case Y: {
                    type = DirectCursedBarkBlock.Type.VERTICAL;
                    break;
                }
                case Z: {
                    type = direction.getAxis() == Direction.Axis.X ? DirectCursedBarkBlock.Type.HORIZONTAL : DirectCursedBarkBlock.Type.VERTICAL;
                }
            }
        } else {
            return;
        }
        BlockPos pos1 = pos.relative(direction);
        BlockState state1 = level.getBlockState(pos1);
        if (state1.isAir() || state1.is((Block)ModBlocks.DIAGONAL_CURSED_BARK.get())) {
            state1 = ((DirectCursedBarkBlock)ModBlocks.DIRECT_CURSED_BARK.get()).defaultBlockState();
            level.setBlockAndUpdate(pos1, (BlockState)state1.setValue((Property)DirectCursedBarkBlock.SIDE_MAP.get((Object)direction.getOpposite()), (Comparable)((Object)type)));
        } else if (!state1.is((Block)ModBlocks.DIRECT_CURSED_BARK.get())) {
            return;
        }
        if (state1.is((Block)ModBlocks.DIRECT_CURSED_BARK.get())) {
            directions = Arrays.stream(Direction.values()).collect(Collectors.toList());
            directions.remove(direction);
            directions.remove(direction.getOpposite());
            for (Direction direction1 : directions) {
                BlockState state2 = level.getBlockState(pos.relative(direction1));
                if (!state2.is((Block)ModBlocks.DIRECT_CURSED_BARK.get()) || state2.getValue((Property)DirectCursedBarkBlock.SIDE_MAP.get((Object)direction1.getOpposite())) == DirectCursedBarkBlock.Type.NONE) continue;
                BlockState diagonalState = level.getBlockState(pos1.relative(direction1));
                if (diagonalState.isAir()) {
                    diagonalState = ((DiagonalCursedBarkBlock)ModBlocks.DIAGONAL_CURSED_BARK.get()).defaultBlockState();
                }
                if (!diagonalState.is((Block)ModBlocks.DIAGONAL_CURSED_BARK.get())) continue;
                level.setBlockAndUpdate(pos1.relative(direction1), (BlockState)diagonalState.setValue((Property)DiagonalCursedBarkBlock.PROPERTY_TABLE.get((Object)direction.getOpposite(), (Object)direction1.getOpposite()), (Comparable)Boolean.valueOf(true)));
            }
        }
    }
}

