/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.mojang.serialization.MapCodec;
import de.teamlapen.lib.lib.util.ModDisplayItemGenerator;
import de.teamlapen.vampirism.blockentity.BloodContainerBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModDataComponents;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.component.ContainedFluid;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BloodContainerBlock
extends VampirismBlockContainer
implements ModDisplayItemGenerator.CreativeTabItemProvider {
    protected static final VoxelShape containerShape = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final MapCodec<BloodContainerBlock> CODEC = BloodContainerBlock.simpleCodec(BloodContainerBlock::new);
    private static final Logger LOGGER = LogManager.getLogger();

    public static FluidStack getFluidFromItemStack(@NotNull ItemStack stack) {
        return ContainedFluid.get(stack);
    }

    public static void writeFluidToItemStack(@NotNull ItemStack stack, @NotNull FluidStack fluid) {
        if (fluid.isEmpty()) {
            stack.remove(ModDataComponents.BLOOD_CONTAINER);
        } else {
            stack.set(ModDataComponents.BLOOD_CONTAINER, (Object)new ContainedFluid(fluid));
        }
    }

    public BloodContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        FluidStack fluidStack = ContainedFluid.get(stack);
        if (!fluidStack.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)fluidStack.getFluidType().getDescriptionId(fluidStack)).append((Component)Component.literal((String)(": " + fluidStack.getAmount() + "mB"))).withStyle(ChatFormatting.DARK_RED));
        }
    }

    @Override
    public void generateCreativeTab(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        ItemStack stack = new ItemStack((ItemLike)this, 1);
        output.accept(stack);
        stack = stack.copy();
        FluidStack fluid = new FluidStack((Fluid)ModFluids.BLOOD.get(), 12600);
        stack.set(ModDataComponents.BLOOD_CONTAINER, (Object)new ContainedFluid(fluid));
        output.accept(stack);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new BloodContainerBlockEntity(pos, state);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return containerShape;
    }

    public void playerDestroy(@NotNull Level worldIn, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity te, @NotNull ItemStack heldStack) {
        FluidStack fluid;
        ItemStack stack = new ItemStack((ItemLike)ModBlocks.BLOOD_CONTAINER.get(), 1);
        if (te != null && !(fluid = ((BloodContainerBlockEntity)te).getFluid()).isEmpty() && fluid.getAmount() >= 100) {
            BloodContainerBlock.writeFluidToItemStack(stack, fluid);
        }
        BloodContainerBlock.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)stack);
    }

    public void setPlacedBy(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, LivingEntity placer, @NotNull ItemStack stack) {
        BlockEntity tile;
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        FluidStack fluid = BloodContainerBlock.getFluidFromItemStack(stack);
        if (!stack.isEmpty() && (tile = worldIn.getBlockEntity(pos)) instanceof BloodContainerBlockEntity) {
            ((BloodContainerBlockEntity)tile).setFluidStack(fluid);
            tile.setChanged();
        }
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, @NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player playerIn, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (!FluidUtil.interactWithFluidHandler((Player)playerIn, (InteractionHand)hand, (Level)worldIn, (BlockPos)pos, (Direction)hit.getDirection()) && stack.getItem().equals(Items.GLASS_BOTTLE) && ((Boolean)VampirismConfig.COMMON.autoConvertGlassBottles.get()).booleanValue()) {
            FluidUtil.getFluidHandler((Level)worldIn, (BlockPos)pos, (Direction)hit.getDirection()).ifPresent(fluidHandler -> {
                if (fluidHandler.getFluidInTank(0).getFluid().equals(ModFluids.BLOOD.get())) {
                    ItemStack glass = playerIn.getItemInHand(hand);
                    ItemStack bloodBottle = FluidUtil.tryFillContainer((ItemStack)new ItemStack((ItemLike)ModItems.BLOOD_BOTTLE.get(), 1), (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, (Player)playerIn, (boolean)true).getResult();
                    if (bloodBottle.isEmpty()) {
                        playerIn.displayClientMessage((Component)Component.translatable((String)"text.vampirism.container.not_enough_blood"), true);
                    } else if (glass.getCount() > 1) {
                        glass.shrink(1);
                        playerIn.setItemInHand(hand, glass);
                        playerIn.addItem(bloodBottle);
                    } else {
                        playerIn.setItemInHand(hand, bloodBottle);
                    }
                }
            });
        }
        return ItemInteractionResult.SUCCESS;
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos) {
        return FluidUtil.getFluidHandler((Level)pLevel, (BlockPos)pPos, null).map(handler -> (int)((float)handler.getFluidInTank(0).getAmount() * 14.0f / (float)handler.getTankCapacity(0))).orElse(0);
    }
}

