/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.lib.lib.util.SpawnHelper;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blockentity.MotherBlockEntity;
import de.teamlapen.vampirism.blocks.mother.MotherTreeStructure;
import de.teamlapen.vampirism.blocks.mother.RemainsBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.VulnerableRemainsDummyEntity;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VulnerableRemainsBlockEntity
extends BlockEntity {
    public static final int MAX_HEALTH = 100;
    private BlockPos motherPos;
    private int health = 100;
    @Nullable
    private UUID dummy_entity_id;
    private boolean spawnedBackup;
    private long lastDamage = 0L;
    private boolean firstTick = true;

    public static void serverTick(ServerLevel level, BlockPos blockPos, BlockState blockState, VulnerableRemainsBlockEntity e) {
        if (e.firstTick) {
            e.firstTick = false;
            e.getMother().ifPresent(mother -> {
                mother.updateFightStatus();
                e.checkDummyEntity(level, blockPos);
            });
        } else if (level.getGameTime() % 128L == 3L) {
            e.checkDummyEntity(level, blockPos);
            if (e.lastDamage - level.getGameTime() > 3600L) {
                e.health = Math.min(e.health + 10, 100);
                if (e.health == 100) {
                    e.spawnedBackup = false;
                }
            }
        }
    }

    public VulnerableRemainsBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTiles.VULNERABLE_CURSED_ROOTED_DIRT.get(), pos, state);
    }

    private void destroyVulnerability() {
        this.level.setBlockAndUpdate(this.worldPosition, ((RemainsBlock)ModBlocks.INCAPACITATED_VULNERABLE_REMAINS.get()).defaultBlockState());
    }

    public void loadAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.health = tag.getInt("health");
        this.lastDamage = tag.getLong("lastDamage");
        if (tag.contains("motherPos")) {
            int[] pos = tag.getIntArray("motherPos");
            this.motherPos = new BlockPos(pos[0], pos[1], pos[2]);
        }
        if (tag.contains("dummy_entity_id", 11)) {
            this.dummy_entity_id = tag.getUUID("dummy_entity_id");
        }
    }

    public void onDamageDealt(DamageSource src, double damage) {
        Entity entity;
        this.health -= (int)damage;
        if (this.level != null) {
            this.lastDamage = this.level.getGameTime();
        }
        if (this.health <= 0) {
            this.destroyVulnerability();
        }
        if ((entity = src.getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            this.getMother().ifPresent(mother -> mother.onVulnerabilityHit(entity2, this.health <= 0));
        }
        if (!this.spawnedBackup && this.health <= 50 && (entity = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entity;
            this.checkDummyEntity(serverLevel, this.worldPosition).spawnDefenders();
            this.spawnedBackup = true;
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("health", this.health);
        tag.putLong("lastDamage", this.lastDamage);
        if (this.motherPos != null) {
            tag.putIntArray("motherPos", new int[]{this.motherPos.getX(), this.motherPos.getY(), this.motherPos.getZ()});
        }
        if (this.dummy_entity_id != null) {
            tag.putUUID("dummy_entity_id", this.dummy_entity_id);
        }
    }

    private VulnerableRemainsDummyEntity checkDummyEntity(ServerLevel level, BlockPos blockPos) {
        if (this.dummy_entity_id != null) {
            Entity e = level.getEntity(this.dummy_entity_id);
            if (e instanceof VulnerableRemainsDummyEntity) {
                VulnerableRemainsDummyEntity dummy = (VulnerableRemainsDummyEntity)e;
                return dummy;
            }
            this.dummy_entity_id = null;
        }
        return SpawnHelper.spawn(ModEntities.VULNERABLE_REMAINS_DUMMY, (Level)level, entity -> {
            entity.setPos(Vec3.atCenterOf((Vec3i)blockPos).add(0.0, (double)-0.51f, 0.0));
            entity.setOwnerLocation(blockPos);
            this.dummy_entity_id = entity.getUUID();
        });
    }

    public int getHealth() {
        return this.health;
    }

    public Optional<MotherBlockEntity> getMother() {
        if (this.level != null) {
            return MotherTreeStructure.findMother((LevelAccessor)this.level, this.getBlockPos()).map(p -> this.level.getBlockEntity((BlockPos)p.getKey())).filter(MotherBlockEntity.class::isInstance).map(MotherBlockEntity.class::cast);
        }
        return Optional.empty();
    }

    public void checkNeighbor(BlockPos pNeighborPos) {
        Direction direction;
        ServerLevel serverLevel;
        Level level = this.level;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getBlockState(pNeighborPos).isAir() && (direction = UtilLib.getDirection(this.getBlockPos(), pNeighborPos)) != null) {
            this.checkDummyEntity(serverLevel, this.getBlockPos()).spawnDefender(direction.getOpposite());
        }
    }

    public void setRemoved() {
        Level level;
        super.setRemoved();
        if (this.dummy_entity_id != null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Optional.ofNullable(serverLevel.getEntity(this.dummy_entity_id)).ifPresent(entity -> {
                entity.playSound(((VulnerableRemainsDummyEntity)entity).getDeathSound());
                entity.remove(Entity.RemovalReason.DISCARDED);
            });
        }
    }

    public void onPlaced() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.checkDummyEntity(serverLevel, this.getBlockPos()).spawnDefenders();
        }
    }
}

