/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.DamageHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GarlicDiffuserBlockEntity
extends BlockEntity {
    private static final int FUEL_DURATION = 2400;
    private int id;
    private EnumStrength strength = EnumStrength.MEDIUM;
    @NotNull
    private EnumStrength defaultStrength = EnumStrength.MEDIUM;
    private int r = 1;
    private boolean registered = false;
    private int fueled = 0;
    private int bootTimer = -1;
    private int maxBootTimer;
    private boolean initiateBootTimer = false;

    public GarlicDiffuserBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModTiles.GARLIC_DIFFUSER.get(), pos, state);
    }

    public float getBootProgress() {
        return this.bootTimer > 0 ? 1.0f - (float)this.bootTimer / (float)this.maxBootTimer : 1.0f;
    }

    public int getFuelTime() {
        return this.fueled;
    }

    public float getFueledState() {
        return (float)this.fueled / 2400.0f;
    }

    public void clearRemoved() {
        super.clearRemoved();
        if (this.isActive()) {
            this.register();
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public boolean isActive() {
        return this.bootTimer == 0;
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public boolean isInRange(@NotNull BlockPos pos) {
        return new ChunkPos(this.getBlockPos()).getChessboardDistance(new ChunkPos(pos)) <= this.r;
    }

    public void loadAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.r = compound.getInt("radius");
        this.defaultStrength = EnumStrength.getFromStrength(compound.getInt("strength"));
        this.bootTimer = compound.getInt("boot_timer");
        this.maxBootTimer = compound.contains("max_boot_timer") ? compound.getInt("max_boot_timer") : 1;
        this.setFueledTime(compound.getInt("fueled"));
    }

    public void onDataPacket(Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        if (this.hasLevel()) {
            CompoundTag nbt = pkt.getTag();
            this.handleUpdateTag(nbt, provider);
            if (this.isActive()) {
                this.register();
            }
        }
    }

    public void onTouched(@NotNull Player player) {
        if (VampirismPlayerAttributes.get((Player)player).vampireLevel > 0) {
            DamageHandler.affectVampireGarlicDirect(VampirePlayer.get(player), this.strength);
        }
    }

    public void onFueled() {
        this.setFueledTime(2400);
        this.updateLevel();
    }

    public void saveAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("radius", this.r);
        compound.putInt("strength", this.defaultStrength.getStrength());
        compound.putInt("fueled", this.fueled);
        if (this.bootTimer != 0) {
            compound.putInt("boot_timer", this.bootTimer);
            compound.putInt("max_boot_timer", this.maxBootTimer);
        }
    }

    public void setNewBootDelay(int delayTicks) {
        this.bootTimer = delayTicks;
        this.maxBootTimer = delayTicks;
    }

    public void initiateBootTimer() {
        this.initiateBootTimer = true;
    }

    public void setType( @NotNull GarlicDiffuserBlock.Type type) {
        switch (type) {
            case WEAK: {
                this.r = (Integer)VampirismConfig.BALANCE.hsGarlicDiffuserWeakDist.get();
                this.defaultStrength = EnumStrength.WEAK;
                break;
            }
            case NORMAL: {
                this.r = (Integer)VampirismConfig.BALANCE.hsGarlicDiffuserNormalDist.get();
                this.defaultStrength = EnumStrength.MEDIUM;
                break;
            }
            case IMPROVED: {
                this.defaultStrength = EnumStrength.MEDIUM;
                this.r = (Integer)VampirismConfig.BALANCE.hsGarlicDiffuserEnhancedDist.get();
            }
        }
        this.strength = this.defaultStrength;
    }

    public void updateLevel() {
        this.setChanged();
        if (this.hasLevel()) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void setRemoved() {
        super.setRemoved();
        this.unregister();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, @NotNull GarlicDiffuserBlockEntity blockEntity) {
        if (blockEntity.initiateBootTimer && !level.isClientSide) {
            ServerLevel serverLevel;
            blockEntity.initiateBootTimer = false;
            int bootTime = (Integer)VampirismConfig.BALANCE.garlicDiffuserStartupTime.get() * 20;
            if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).players().size() <= 1) {
                bootTime >>= 2;
            }
            blockEntity.bootTimer = bootTime;
            blockEntity.maxBootTimer = bootTime;
            blockEntity.updateLevel();
        }
        if (blockEntity.bootTimer > 0) {
            if (--blockEntity.bootTimer == 0) {
                blockEntity.updateLevel();
                blockEntity.register();
            }
        } else if (blockEntity.fueled > 0) {
            if (blockEntity.fueled == 1) {
                blockEntity.setFueledTime(0);
                blockEntity.updateLevel();
            } else {
                --blockEntity.fueled;
                blockEntity.setChanged();
            }
        }
    }

    private void register() {
        if (this.registered || !this.hasLevel()) {
            return;
        }
        int baseX = this.getBlockPos().getX() >> 4;
        int baseZ = this.getBlockPos().getZ() >> 4;
        ChunkPos[] chunks = new ChunkPos[(2 * this.r + 1) * (2 * this.r + 1)];
        int i = 0;
        for (int x = -this.r; x <= this.r; ++x) {
            for (int z = -this.r; z <= this.r; ++z) {
                chunks[i++] = new ChunkPos(x + baseX, z + baseZ);
            }
        }
        this.id = VampirismAPI.garlicHandler(this.getLevel()).registerGarlicBlock(this.strength, chunks);
        this.registered = i != 0;
    }

    private void setFueledTime(int time) {
        int old = this.fueled;
        this.fueled = time;
        this.strength = this.fueled > 0 ? EnumStrength.STRONG : this.defaultStrength;
        if ((time > 0 && old == 0 || time == 0 && old > 0) && !this.isRemoved()) {
            this.unregister();
            this.register();
        }
    }

    private void unregister() {
        if (this.registered && this.hasLevel()) {
            VampirismAPI.garlicHandler(this.getLevel()).removeGarlicBlock(this.id);
            this.registered = false;
        }
    }
}

