/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.blocks.AlchemyTableBlock;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.inventory.AlchemyTableMenu;
import de.teamlapen.vampirism.items.component.OilContent;
import de.teamlapen.vampirism.recipes.AlchemyTableRecipe;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchemyTableBlockEntity
extends BaseContainerBlockEntity {
    @NotNull
    private NonNullList<ItemStack> items = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
    private int brewTime;
    private boolean @Nullable [] lastOilCount;
    private Item ingredient;
    private int fuel;
    private int productColor;
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int slotId) {
            return switch (slotId) {
                case 0 -> AlchemyTableBlockEntity.this.brewTime;
                case 1 -> AlchemyTableBlockEntity.this.fuel;
                case 2 -> AlchemyTableBlockEntity.this.productColor;
                default -> 0;
            };
        }

        public void set(int slotId, int value) {
            switch (slotId) {
                case 0: {
                    AlchemyTableBlockEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    AlchemyTableBlockEntity.this.fuel = value;
                    break;
                }
                case 2: {
                    AlchemyTableBlockEntity.this.productColor = value;
                }
            }
        }

        public int getCount() {
            return 3;
        }
    };

    public AlchemyTableBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModTiles.ALCHEMICAL_TABLE.get(), pos, state);
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"container.vampirism.alchemy_table");
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int menuId, @NotNull Inventory playerInventory) {
        return new AlchemyTableMenu(menuId, this.level, playerInventory, (Container)this, this.dataAccess);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean[] getPotionBits() {
        boolean[] aboolean = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            if (((ItemStack)this.items.get(i)).isEmpty()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    @NotNull
    public ItemStack getItem(int p_70301_1_) {
        return p_70301_1_ >= 0 && p_70301_1_ < this.items.size() ? (ItemStack)this.items.get(p_70301_1_) : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack removeItem(int p_70298_1_, int p_70298_2_) {
        return ContainerHelper.removeItem(this.items, (int)p_70298_1_, (int)p_70298_2_);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int p_70304_1_) {
        return ContainerHelper.takeItem(this.items, (int)p_70304_1_);
    }

    public void setItem(int p_70299_1_, @NotNull ItemStack stack) {
        if (p_70299_1_ >= 0 && p_70299_1_ < this.items.size()) {
            this.items.set(p_70299_1_, (Object)stack);
        }
    }

    public boolean stillValid(@NotNull Player player) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    public void clearContent() {
        this.items.clear();
    }

    public static void serverTick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull AlchemyTableBlockEntity blockEntity) {
        ItemStack itemstack = (ItemStack)blockEntity.items.get(5);
        if (blockEntity.fuel <= 0 && itemstack.getItem() == Items.BLAZE_POWDER) {
            blockEntity.fuel = 20;
            itemstack.shrink(1);
            blockEntity.setChanged();
        }
        boolean flag = blockEntity.isBrewable(level);
        boolean flag1 = blockEntity.brewTime > 0;
        ItemStack itemstack1 = (ItemStack)blockEntity.items.get(4);
        if (flag1) {
            boolean flag2;
            --blockEntity.brewTime;
            boolean bl = flag2 = blockEntity.brewTime == 0;
            if (flag2 && flag) {
                blockEntity.doBrew(level);
                blockEntity.setChanged();
            } else if (!flag) {
                blockEntity.brewTime = 0;
                blockEntity.setChanged();
            } else if (blockEntity.ingredient != itemstack1.getItem()) {
                blockEntity.brewTime = 0;
                blockEntity.setChanged();
            }
        } else if (flag && blockEntity.fuel > 0) {
            --blockEntity.fuel;
            blockEntity.brewTime = 600;
            blockEntity.ingredient = itemstack1.getItem();
            blockEntity.productColor = level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipes.ALCHEMICAL_TABLE_TYPE.get()).stream().filter(recipe -> ((AlchemyTableRecipe)recipe.value()).isInput((ItemStack)blockEntity.items.get(4)) && (((AlchemyTableRecipe)recipe.value()).isIngredient((ItemStack)blockEntity.items.getFirst()) || ((AlchemyTableRecipe)recipe.value()).isIngredient((ItemStack)blockEntity.items.get(1)))).map(recipe -> ((AlchemyTableRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess())).map(s -> ((IOil)OilContent.getOil(s).value()).getColor()).findAny().orElse(0xFFFFFF);
            blockEntity.setChanged();
        }
        boolean[] aboolean = blockEntity.getPotionBits();
        if (!Arrays.equals(aboolean, blockEntity.lastOilCount)) {
            blockEntity.lastOilCount = aboolean;
            if (!(state.getBlock() instanceof AlchemyTableBlock)) {
                return;
            }
            state = (BlockState)state.setValue((Property)AlchemyTableBlock.HAS_BOTTLE_INPUT_0, (Comparable)Boolean.valueOf(aboolean[0]));
            state = (BlockState)state.setValue((Property)AlchemyTableBlock.HAS_BOTTLE_INPUT_1, (Comparable)Boolean.valueOf(aboolean[1]));
            state = (BlockState)state.setValue((Property)AlchemyTableBlock.HAS_BOTTLE_OUTPUT_0, (Comparable)Boolean.valueOf(aboolean[2]));
            state = (BlockState)state.setValue((Property)AlchemyTableBlock.HAS_BOTTLE_OUTPUT_1, (Comparable)Boolean.valueOf(aboolean[3]));
            level.setBlock(pos, state, 2);
        }
    }

    private boolean isBrewable(@NotNull Level level) {
        ItemStack itemstack = (ItemStack)this.items.get(4);
        if (itemstack.isEmpty()) {
            return false;
        }
        if (!this.isValidInput(level, itemstack)) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            ItemStack itemstack1;
            if (!((ItemStack)this.items.get(i + 2)).isEmpty() || (itemstack1 = (ItemStack)this.items.get(i)).isEmpty() || !this.hasRecipe(level, itemstack, itemstack1)) continue;
            return true;
        }
        return false;
    }

    private void doBrew(@NotNull Level level) {
        ItemStack itemstack = (ItemStack)this.items.get(4);
        for (int i = 0; i < 2; ++i) {
            if (!((ItemStack)this.items.get(i + 2)).isEmpty()) continue;
            ItemStack stack = this.getOutput(level, itemstack, (ItemStack)this.items.get(i));
            this.items.set(i, (Object)ItemStack.EMPTY);
            this.items.set(i + 2, (Object)stack);
        }
        BlockPos blockpos = this.getBlockPos();
        if (itemstack.hasCraftingRemainingItem()) {
            ItemStack itemstack1 = itemstack.getCraftingRemainingItem();
            itemstack.shrink(1);
            if (itemstack.isEmpty()) {
                itemstack = itemstack1;
            } else if (!level.isClientSide) {
                Containers.dropItemStack((Level)level, (double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), (ItemStack)itemstack1);
            }
        } else {
            itemstack.shrink(1);
        }
        this.items.set(4, (Object)itemstack);
        level.levelEvent(1035, blockpos, 0);
    }

    public boolean canPlaceItem(int p_94041_1_, @NotNull ItemStack stack) {
        if (p_94041_1_ == 3) {
            return this.isValidIngredient(this.level, stack);
        }
        Item item = stack.getItem();
        if (p_94041_1_ == 4) {
            return item == Items.BLAZE_POWDER;
        }
        return this.isValidInput(this.level, stack) && this.getItem(p_94041_1_).isEmpty();
    }

    private boolean hasRecipe(@NotNull Level level, @NotNull ItemStack input, @NotNull ItemStack ingredient) {
        return level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipes.ALCHEMICAL_TABLE_TYPE.get()).stream().anyMatch(recipe -> ((AlchemyTableRecipe)recipe.value()).isInput(input) && ((AlchemyTableRecipe)recipe.value()).isIngredient(ingredient));
    }

    public boolean isValidIngredient(@NotNull Level level, @NotNull ItemStack stack) {
        return level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipes.ALCHEMICAL_TABLE_TYPE.get()).stream().anyMatch(recipe -> ((AlchemyTableRecipe)recipe.value()).isIngredient(stack));
    }

    public boolean isValidInput(@NotNull Level level, @NotNull ItemStack stack) {
        return level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipes.ALCHEMICAL_TABLE_TYPE.get()).stream().anyMatch(recipe -> ((AlchemyTableRecipe)recipe.value()).isInput(stack));
    }

    @NotNull
    public ItemStack getOutput(@NotNull Level level, @NotNull ItemStack input, @NotNull ItemStack ingredient) {
        return level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipes.ALCHEMICAL_TABLE_TYPE.get()).stream().map(recipe -> ((AlchemyTableRecipe)recipe.value()).getResult(input, ingredient)).filter(a -> !a.isEmpty()).findFirst().orElse(ItemStack.EMPTY);
    }

    public void loadAdditional(@NotNull CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)lookupProvider);
        this.brewTime = tag.getShort("BrewTime");
        this.fuel = tag.getByte("Fuel");
    }

    public void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        tag.putShort("BrewTime", (short)this.brewTime);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)lookupProvider);
        tag.putByte("Fuel", (byte)this.fuel);
    }
}

