/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.core.ModAdvancements;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FactionCriterionTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public void trigger(@NotNull ServerPlayer player, IPlayableFaction<?> faction, int level, int lordLevel) {
        this.trigger(player, instance -> instance.matches(faction, level, lordLevel));
    }

    public void revokeAll(ServerPlayer player) {
        this.revoke(player, instance -> true);
    }

    public void revokeLevel(ServerPlayer player, IPlayableFaction<?> faction, Type type, int newLevel) {
        this.revoke(player, instance -> instance.faction == faction && instance.type == type && instance.level > newLevel);
    }

    private void revoke(ServerPlayer player, Predicate<TriggerInstance> instancePredicate) {
    }

    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public static enum Type implements StringRepresentable
    {
        LEVEL("level"),
        LORD("lord");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }

    public record TriggerInstance(@NotNull Optional<ContextAwarePredicate> player, @NotNull Type type, @Nullable IPlayableFaction<?> faction, int level) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)StringRepresentable.fromEnum(Type::values).fieldOf("type").forGetter(TriggerInstance::type), (App)IPlayableFaction.CODEC.optionalFieldOf("faction").forGetter(p -> Optional.ofNullable(p.faction())), (App)ExtraCodecs.POSITIVE_INT.fieldOf("level").forGetter(TriggerInstance::level)).apply((Applicative)inst, TriggerInstance::new));

        public TriggerInstance(@NotNull Optional<ContextAwarePredicate> player, @NotNull Type type, @NotNull Optional<IPlayableFaction<?>> faction, int level) {
            this(player, type, (IPlayableFaction<?>)faction.orElse(null), level);
        }

        public static Criterion<TriggerInstance> level(@Nullable IPlayableFaction<?> faction, int level) {
            return ((FactionCriterionTrigger)((Object)ModAdvancements.TRIGGER_FACTION.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Type.LEVEL, faction, level));
        }

        public static Criterion<TriggerInstance> lord(@Nullable IPlayableFaction<?> faction, int level) {
            return ((FactionCriterionTrigger)((Object)ModAdvancements.TRIGGER_FACTION.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Type.LORD, faction, level));
        }

        public boolean matches(IPlayableFaction<?> faction, int level, int lordLevel) {
            if (faction == null && this.faction == null || Objects.equals(this.faction, faction)) {
                if (this.type == Type.LEVEL) {
                    return level >= this.level;
                }
                if (this.type == Type.LORD) {
                    return lordLevel >= this.level;
                }
            }
            return false;
        }
    }
}

