/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.network;

import com.google.common.collect.ImmutableCollection;
import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.lib.storage.IAttachedSyncable;
import de.teamlapen.lib.lib.storage.ISyncable;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientboundUpdateEntityPacket
implements CustomPacketPayload {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CustomPacketPayload.Type<ClientboundUpdateEntityPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"teamlapenlib", (String)"update_entity"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundUpdateEntityPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ClientboundUpdateEntityPacket::getId, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.COMPOUND_TAG), s -> Optional.ofNullable(s.data), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.COMPOUND_TAG), s -> Optional.ofNullable(s.attachments), (StreamCodec)ByteBufCodecs.BOOL, ClientboundUpdateEntityPacket::isPlayerItself, ClientboundUpdateEntityPacket::new);
    private int id;
    @Nullable
    private CompoundTag data;
    @Nullable
    private CompoundTag attachments;
    private boolean playerItself = false;

    @NotNull
    public static ClientboundUpdateEntityPacket create(HolderLookup.Provider provider, @NotNull IAttachedSyncable cap) {
        return ClientboundUpdateEntityPacket.create(cap, cap.serializeUpdateNBT(provider));
    }

    @NotNull
    public static ClientboundUpdateEntityPacket create(Mob entity, IAttachedSyncable ... caps) {
        if (!(entity instanceof ISyncable)) {
            throw new IllegalArgumentException("You cannot use this packet to sync this entity. The entity has to implement ISyncable");
        }
        ClientboundUpdateEntityPacket packet = ClientboundUpdateEntityPacket.create((HolderLookup.Provider)entity.registryAccess(), caps);
        packet.data = ((ISyncable)entity).serializeUpdateNBT((HolderLookup.Provider)entity.registryAccess());
        return packet;
    }

    @NotNull
    public static ClientboundUpdateEntityPacket create(HolderLookup.Provider provider, IAttachedSyncable ... caps) {
        CompoundTag capsTag = new CompoundTag();
        for (IAttachedSyncable cap : caps) {
            capsTag.put(cap.getAttachedKey().toString(), (Tag)cap.serializeUpdateNBT(provider));
        }
        return new ClientboundUpdateEntityPacket(caps[0].asEntity().getId(), null, capsTag, false);
    }

    @NotNull
    public static ClientboundUpdateEntityPacket create(@NotNull IAttachedSyncable cap, @NotNull CompoundTag data) {
        CompoundTag tag = new CompoundTag();
        tag.put(cap.getAttachedKey().toString(), (Tag)data);
        return new ClientboundUpdateEntityPacket(cap.asEntity().getId(), null, tag, false);
    }

    @NotNull
    public static ClientboundUpdateEntityPacket create(Entity entity) {
        if (!(entity instanceof ISyncable)) {
            throw new IllegalArgumentException("You cannot use this packet to sync this entity. The entity has to implement ISyncable");
        }
        return new ClientboundUpdateEntityPacket(entity.getId(), ((ISyncable)entity).serializeUpdateNBT((HolderLookup.Provider)entity.registryAccess()), null, false);
    }

    @NotNull
    public static <T extends Entity> ClientboundUpdateEntityPacket create(@NotNull T entity, CompoundTag data) {
        return new ClientboundUpdateEntityPacket(entity.getId(), data, null, false);
    }

    @Nullable
    public static ClientboundUpdateEntityPacket createJoinWorldPacket(Entity entity) {
        ArrayList capsToSync = new ArrayList();
        ImmutableCollection allCaps = null;
        if (entity instanceof PathfinderMob) {
            allCaps = HelperRegistry.getSyncableEntityCaps().values();
        } else if (entity instanceof Player) {
            allCaps = HelperRegistry.getSyncablePlayerCaps().values();
        }
        if (allCaps != null && !allCaps.isEmpty()) {
            for (AttachmentType cap : allCaps) {
                Optional.of((IAttachedSyncable)entity.getData(cap)).ifPresent(capsToSync::add);
            }
        }
        if (!capsToSync.isEmpty()) {
            if (entity instanceof ISyncable) {
                return ClientboundUpdateEntityPacket.create((Mob)entity, capsToSync.toArray(new IAttachedSyncable[0]));
            }
            return ClientboundUpdateEntityPacket.create((HolderLookup.Provider)entity.registryAccess(), capsToSync.toArray(new IAttachedSyncable[0]));
        }
        if (entity instanceof ISyncable) {
            return ClientboundUpdateEntityPacket.create(entity);
        }
        LOGGER.warn("There is nothing to update for entity {}", (Object)entity);
        return null;
    }

    private ClientboundUpdateEntityPacket(int id, Optional<CompoundTag> data, Optional<CompoundTag> attachments, boolean playerItself) {
        this(id, (CompoundTag)data.orElse(null), (CompoundTag)attachments.orElse(null), playerItself);
    }

    private ClientboundUpdateEntityPacket(int id, @Nullable CompoundTag data, @Nullable CompoundTag attackments, boolean playerItself) {
        this.id = id;
        this.data = data;
        this.attachments = attackments;
        this.playerItself = playerItself;
    }

    @Nullable
    public CompoundTag getAttachments() {
        return this.attachments;
    }

    @Nullable
    public CompoundTag getData() {
        return this.data;
    }

    public int getId() {
        return this.id;
    }

    public boolean isPlayerItself() {
        return this.playerItself;
    }

    @NotNull
    public ClientboundUpdateEntityPacket markAsPlayerItself() {
        this.playerItself = true;
        return this;
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

