/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilLib {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern oldFormatPattern = Pattern.compile("%[sd]");

    @NotNull
    public static String entityToString(@Nullable Entity e) {
        if (e == null) {
            return "Entity is null";
        }
        return e.toString();
    }

    public static boolean doesBlockHaveSolidTopSurface(@NotNull Level worldIn, @NotNull BlockPos pos) {
        return worldIn.getBlockState(pos).isFaceSturdy((BlockGetter)worldIn, pos, Direction.UP);
    }

    @NotNull
    public static HitResult getPlayerLookingSpot(@NotNull Player player, double restriction) {
        float scale = 1.0f;
        float pitch = player.xRotO + (player.getXRot() - player.xRotO) * scale;
        float yaw = player.yRotO + (player.getYRot() - player.yRotO) * scale;
        double x = player.xo + (player.getX() - player.xo) * (double)scale;
        double y = player.yo + (player.getY() - player.yo) * (double)scale + 1.62;
        double z = player.zo + (player.getZ() - player.zo) * (double)scale;
        Vec3 vector1 = new Vec3(x, y, z);
        float cosYaw = Mth.cos((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = Mth.sin((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float cosPitch = -Mth.cos((float)(-pitch * ((float)Math.PI / 180)));
        float sinPitch = Mth.sin((float)(-pitch * ((float)Math.PI / 180)));
        float pitchAdjustedSinYaw = sinYaw * cosPitch;
        float pitchAdjustedCosYaw = cosYaw * cosPitch;
        double distance = 500.0;
        if (restriction == 0.0 && player instanceof ServerPlayer) {
            distance = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue() - 0.5;
        } else if (restriction > 0.0) {
            distance = restriction;
        }
        Vec3 vector2 = vector1.add((double)pitchAdjustedSinYaw * distance, (double)sinPitch * distance, (double)pitchAdjustedCosYaw * distance);
        return player.getCommandSenderWorld().clip(new ClipContext(vector1, vector2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
    }

    @NotNull
    public static BlockPos getRandomPosInBox(@NotNull Level w, @NotNull AABB box) {
        int x = (int)box.minX + w.random.nextInt((int)(box.maxX - box.minX) + 1);
        int z = (int)box.minZ + w.random.nextInt((int)(box.maxZ - box.minZ) + 1);
        int y = w.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z) + 5;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while ((double)y > box.minY && !w.getBlockState((BlockPos)pos).isRedstoneConductor((BlockGetter)w, (BlockPos)pos)) {
            pos.set(x, --y, z);
        }
        if ((double)y < box.minY || (double)y > box.maxY - 1.0) {
            pos.set(x, (int)box.minY + w.random.nextInt((int)(box.maxY - box.minY) + 1), z);
        }
        return pos.above();
    }

    public static int countPlayerLoadedChunks(@NotNull Level world) {
        ArrayList chunks = Lists.newArrayList();
        int i = 0;
        for (Player player : world.players()) {
            if (player.isSpectator()) continue;
            int x = Mth.floor((double)(player.getX() / 16.0));
            int z = Mth.floor((double)(player.getZ() / 16.0));
            for (int dx = -8; dx <= 8; ++dx) {
                for (int dz = -8; dz <= 8; ++dz) {
                    ChunkPos chunkpos = new ChunkPos(dx + x, dz + z);
                    if (chunks.contains(chunkpos)) continue;
                    ++i;
                    chunks.add(chunkpos);
                }
            }
        }
        return i;
    }

    @NotNull
    public static Vec3 getItemPosition(@NotNull LivingEntity entity, boolean mainHand) {
        Player player;
        boolean left = (mainHand ? entity.getMainArm() : entity.getMainArm().getOpposite()) == HumanoidArm.LEFT;
        boolean firstPerson = entity instanceof Player && (player = (Player)entity).isLocalPlayer() && Minecraft.getInstance().options.getCameraType().isFirstPerson();
        Vec3 dir = firstPerson ? entity.getForward() : Vec3.directionFromRotation((Vec2)new Vec2(entity.getXRot(), entity.yBodyRot));
        dir = dir.yRot(0.62831855f * (left ? 1.0f : -1.0f)).scale(0.75);
        return dir.add(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ());
    }

    @Nullable
    public static <T extends Mob> Entity spawnEntityBehindEntity(@NotNull LivingEntity entity, @NotNull EntityType<T> toSpawn, @NotNull MobSpawnType reason) {
        BlockPos behind = UtilLib.getPositionBehindEntity(entity, 2.0f);
        Mob e = (Mob)toSpawn.create(entity.getCommandSenderWorld());
        if (e == null) {
            return null;
        }
        Level level = entity.getCommandSenderWorld();
        e.setPos((double)behind.getX(), entity.getY(), (double)behind.getZ());
        if (e.checkSpawnRules((LevelAccessor)level, reason) && e.checkSpawnObstruction((LevelReader)level)) {
            entity.getCommandSenderWorld().addFreshEntity((Entity)e);
            return e;
        }
        int y = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, behind).getY();
        e.setPos((double)behind.getX(), (double)y, (double)behind.getZ());
        if (e.checkSpawnRules((LevelAccessor)level, reason) && e.checkSpawnObstruction((LevelReader)level)) {
            level.addFreshEntity((Entity)e);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                UtilLib.onInitialSpawn(serverLevel, (Entity)e, reason);
            }
            return e;
        }
        e.remove(Entity.RemovalReason.DISCARDED);
        return null;
    }

    private static void onInitialSpawn(@NotNull ServerLevel level, Entity e, @NotNull MobSpawnType reason) {
        if (e instanceof Mob) {
            Mob mob = (Mob)e;
            mob.finalizeSpawn((ServerLevelAccessor)level, e.getCommandSenderWorld().getCurrentDifficultyAt(e.blockPosition()), reason, null);
        }
    }

    @NotNull
    public static BlockPos getPositionBehindEntity(@NotNull LivingEntity p, float distance) {
        float yaw = p.yHeadRot;
        float cosYaw = Mth.cos((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = Mth.sin((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        double x = p.getX() + (double)(sinYaw * distance);
        double z = p.getZ() + (double)(cosYaw * distance);
        return new BlockPos((int)x, (int)p.getY(), (int)z);
    }

    public static boolean spawnEntityInWorld(@NotNull ServerLevel world, @NotNull AABB box, @NotNull Entity e, int maxTry, @NotNull List<? extends LivingEntity> avoidedEntities, @NotNull MobSpawnType reason) {
        if (!world.hasChunksAt((int)box.minX, (int)box.minY, (int)box.minZ, (int)box.maxX, (int)box.maxY, (int)box.maxZ)) {
            return false;
        }
        boolean flag = false;
        int i = 0;
        BlockPos backupPos = null;
        while (!flag && i++ < maxTry) {
            BlockPos c = UtilLib.getRandomPosInBox((Level)world, box);
            if (!world.noCollision(new AABB(c)) || !world.isAreaLoaded(c, 5) || !SpawnPlacements.isSpawnPositionOk((EntityType)e.getType(), (LevelReader)world, (BlockPos)c)) continue;
            e.setPos((double)c.getX(), (double)c.getY() + 0.2, (double)c.getZ());
            if ((!SpawnPlacements.checkSpawnRules((EntityType)e.getType(), (ServerLevelAccessor)world, (MobSpawnType)reason, (BlockPos)c, (RandomSource)world.getRandom()) || e instanceof Mob) && (!((Mob)e).checkSpawnRules((LevelAccessor)world, reason) || !((Mob)e).checkSpawnObstruction((LevelReader)e.getCommandSenderWorld()))) continue;
            backupPos = c;
            for (LivingEntity livingEntity : avoidedEntities) {
                if (livingEntity.distanceToSqr(e) < 500.0 && livingEntity.hasLineOfSight(e)) continue;
                flag = true;
            }
        }
        if (!flag && backupPos != null) {
            e.setPos((double)backupPos.getX(), (double)backupPos.getY() + 0.2, (double)backupPos.getZ());
            flag = true;
        }
        if (flag) {
            world.addFreshEntity(e);
            UtilLib.onInitialSpawn(world, e, reason);
            return true;
        }
        return false;
    }

    @Nullable
    public static Entity spawnEntityInWorld(@NotNull ServerLevel world, @NotNull AABB box, @NotNull EntityType<?> entityType, int maxTry, @NotNull List<? extends LivingEntity> avoidedEntities, @NotNull MobSpawnType reason) {
        Entity e = entityType.create((Level)world);
        if (UtilLib.spawnEntityInWorld(world, box, e, maxTry, avoidedEntities, reason)) {
            return e;
        }
        if (e != null) {
            e.remove(Entity.RemovalReason.DISCARDED);
        }
        return null;
    }

    public static boolean teleportTo(@NotNull Mob entity, double x, double y, double z, boolean sound) {
        double d3 = entity.getX();
        double d4 = entity.getY();
        double d5 = entity.getZ();
        entity.setPosRaw(x, y, z);
        boolean flag = false;
        BlockPos blockPos = entity.blockPosition();
        double ty = y;
        if (entity.getCommandSenderWorld().hasChunkAt(blockPos)) {
            boolean flag1 = false;
            while (!flag1 && blockPos.getY() > 0) {
                BlockState blockState = entity.getCommandSenderWorld().getBlockState(blockPos.below());
                if (blockState.blocksMotion()) {
                    flag1 = true;
                    continue;
                }
                entity.setPosRaw(x, ty -= 1.0, z);
                blockPos = blockPos.below();
            }
            if (flag1) {
                entity.setPos(entity.getX(), entity.getY(), entity.getZ());
                if (entity.getCommandSenderWorld().noCollision((Entity)entity) && !entity.getCommandSenderWorld().containsAnyLiquid(entity.getBoundingBox())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.setPos(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (entity.getRandom().nextFloat() - 0.5f) * 0.2f;
            float f1 = (entity.getRandom().nextFloat() - 0.5f) * 0.2f;
            float f2 = (entity.getRandom().nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (entity.getX() - d3) * d6 + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth() * 2.0;
            double d8 = d4 + (entity.getY() - d4) * d6 + entity.getRandom().nextDouble() * (double)entity.getBbHeight();
            double d9 = d5 + (entity.getZ() - d5) * d6 + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth() * 2.0;
            entity.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.PORTAL, d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        if (sound) {
            entity.getCommandSenderWorld().playLocalSound(d3, d4, d5, SoundEvents.ENDERMAN_TELEPORT, SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            entity.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
        }
        return true;
    }

    public static void spawnParticles(@NotNull Level world, @NotNull ParticleOptions particle, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int amount, float maxOffset) {
        double x = xCoord;
        double y = yCoord;
        double z = zCoord;
        for (int i = 0; i < amount; ++i) {
            world.addParticle(particle, x, y, z, xSpeed, ySpeed, zSpeed);
            RandomSource ran = world.random;
            x = xCoord + ran.nextGaussian() * (double)maxOffset;
            y = yCoord + ran.nextGaussian() * (double)maxOffset;
            z = zCoord + ran.nextGaussian() * (double)maxOffset;
        }
    }

    public static void spawnParticlesAroundEntity(@NotNull LivingEntity e, @NotNull ParticleOptions particle, double maxDistance, int amount) {
        int short1 = amount;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0) - 0.5;
            float f = (e.getRandom().nextFloat() - 0.5f) * 0.2f;
            float f1 = (e.getRandom().nextFloat() - 0.5f) * 0.2f;
            float f2 = (e.getRandom().nextFloat() - 0.5f) * 0.2f;
            double d7 = e.getX() + maxDistance * d6 + (e.getRandom().nextDouble() - 0.5) * (double)e.getBbWidth() * 2.0;
            double d8 = e.getY() + maxDistance / 2.0 * d6 + e.getRandom().nextDouble() * (double)e.getHealth();
            double d9 = e.getZ() + maxDistance * d6 + (e.getRandom().nextDouble() - 0.5) * (double)e.getBbWidth() * 2.0;
            e.getCommandSenderWorld().addParticle(particle, d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
    }

    public static void sendMessageToAllExcept(Player player, @NotNull Component message) {
        for (Player o : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
            if (o.equals((Object)player)) continue;
            o.sendSystemMessage(message);
        }
    }

    public static void sendMessageToAll(@NotNull Component message) {
        UtilLib.sendMessageToAllExcept(null, message);
    }

    public static boolean canReallySee(@NotNull LivingEntity entity, @NotNull LivingEntity target, boolean alsoRaytrace) {
        if (alsoRaytrace && !entity.hasLineOfSight((Entity)target)) {
            return false;
        }
        Vec3 look1 = new Vec3(-Math.sin((double)(entity.yHeadRot / 180.0f) * Math.PI), 0.0, Math.cos((double)(entity.yHeadRot / 180.0f) * Math.PI));
        Vec3 dist = new Vec3(target.getX() - entity.getX(), 0.0, target.getZ() - entity.getZ());
        double alpha = Math.acos((look1 = look1.normalize()).dot(dist = dist.normalize()));
        return alpha < 1.7453292519943295;
    }

    public static void write(@NotNull CompoundTag nbt, String base, @NotNull BlockPos pos) {
        nbt.putInt(base + "_x", pos.getX());
        nbt.putInt(base + "_y", pos.getY());
        nbt.putInt(base + "_z", pos.getZ());
    }

    @NotNull
    public static BlockPos readPos(@NotNull CompoundTag nbt, String base) {
        return new BlockPos(nbt.getInt(base + "_x"), nbt.getInt(base + "_y"), nbt.getInt(base + "_z"));
    }

    public static String @NotNull [] prefix(String prefix, String ... strings) {
        String[] result = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            result[i] = prefix + strings[i];
        }
        return result;
    }

    @NotNull
    public static <T> Predicate<T> getPredicateForClass(@NotNull Class<T> clazz) {
        return clazz::isInstance;
    }

    @NotNull
    public static AABB createBB(@NotNull BlockPos center, int distance, boolean fullY) {
        return new AABB((double)(center.getX() - distance), fullY ? 0.0 : (double)(center.getY() - distance), (double)(center.getZ() - distance), (double)(center.getX() + distance), fullY ? 256.0 : (double)(center.getY() + distance), (double)(center.getZ() + distance));
    }

    public static boolean isNonNull(Object ... objects) {
        for (Object o : objects) {
            if (o != null) continue;
            return false;
        }
        return true;
    }

    public static boolean isPlayerOp(@NotNull Player player) {
        return ServerLifecycleHooks.getCurrentServer().getPlayerList().getOps().get((Object)player.getGameProfile()) != null;
    }

    public static boolean isSameInstanceAsServer() {
        return ServerLifecycleHooks.getCurrentServer() != null;
    }

    @NotNull
    private static String replaceDeprecatedFormatter(@NotNull String text) {
        StringBuilder sb = null;
        Matcher m = oldFormatPattern.matcher(text);
        int i = 0;
        while (m.find()) {
            String t = "{" + i++ + "}";
            if (sb == null) {
                sb = new StringBuilder(text.length());
            }
            m.appendReplacement(sb, t);
        }
        if (sb == null) {
            return text;
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @NotNull
    public static VoxelShape rotateShape(@NotNull VoxelShape shape, RotationAmount rotation) {
        HashSet rotatedShapes = new HashSet();
        shape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> {
            x1 = x1 * 16.0 - 8.0;
            x2 = x2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            if (rotation == RotationAmount.NINETY) {
                rotatedShapes.add(UtilLib.blockBox(8.0 - z1, y1 * 16.0, 8.0 + x1, 8.0 - z2, y2 * 16.0, 8.0 + x2));
            } else if (rotation == RotationAmount.HUNDRED_EIGHTY) {
                rotatedShapes.add(UtilLib.blockBox(8.0 - x1, y1 * 16.0, 8.0 - z1, 8.0 - x2, y2 * 16.0, 8.0 - z2));
            } else if (rotation == RotationAmount.TWO_HUNDRED_SEVENTY) {
                rotatedShapes.add(UtilLib.blockBox(8.0 + z1, y1 * 16.0, 8.0 - x1, 8.0 + z2, y2 * 16.0, 8.0 - x2));
            }
        });
        return rotatedShapes.stream().reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).orElseGet(() -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    }

    @NotNull
    public static VoxelShape rollShape(@NotNull VoxelShape shape, @NotNull Direction direction) {
        HashSet rotatedShapes = new HashSet();
        shape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> {
            y1 = y1 * 16.0 - 8.0;
            y2 = y2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            switch (direction) {
                case NORTH: {
                    z1 = 8.0 - z1;
                    z2 = 8.0 - z2;
                    y1 = 8.0 + y1;
                    y2 = 8.0 + y2;
                    double yMin = Math.min(y1, y2);
                    double yMax = Math.max(y1, y2);
                    double zMin = Math.min(z1, z2);
                    double zMax = Math.max(z1, z2);
                    rotatedShapes.add(Block.box((double)(x1 * 16.0), (double)zMin, (double)yMin, (double)(x2 * 16.0), (double)zMax, (double)yMax));
                    break;
                }
                case SOUTH: {
                    z1 = 8.0 + z1;
                    z2 = 8.0 + z2;
                    y1 = 8.0 - y1;
                    y2 = 8.0 - y2;
                    double yMin = Math.min(y1, y2);
                    double yMax = Math.max(y1, y2);
                    double zMin = Math.min(z1, z2);
                    double zMax = Math.max(z1, z2);
                    rotatedShapes.add(Block.box((double)(x1 * 16.0), (double)zMin, (double)yMin, (double)(x2 * 16.0), (double)zMax, (double)yMax));
                }
            }
        });
        return rotatedShapes.stream().reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).orElseGet(() -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    }

    @NotNull
    public static VoxelShape blockBox(double pX1, double pY1, double pZ1, double pX2, double pY2, double pZ2) {
        return Block.box((double)Math.min(pX1, pX2), (double)Math.min(pY1, pY2), (double)Math.min(pZ1, pZ2), (double)Math.max(pX1, pX2), (double)Math.max(pY1, pY2), (double)Math.max(pZ1, pZ2));
    }

    @Nullable
    public static StructureStart getStructureStartAt(@NotNull Entity entity, @NotNull Structure s) {
        return UtilLib.getStructureStartAt(entity.getCommandSenderWorld(), entity.blockPosition(), s);
    }

    @NotNull
    public static Optional<StructureStart> getStructureStartAt(@NotNull Entity entity, @NotNull TagKey<Structure> s) {
        return UtilLib.getStructureStartAt(entity.getCommandSenderWorld(), entity.blockPosition(), s);
    }

    public static boolean isInsideStructure(Level w, @NotNull BlockPos p, @NotNull Structure s) {
        StructureStart start = UtilLib.getStructureStartAt(w, p, s);
        return start != null && start.isValid();
    }

    public static boolean isInsideStructure(Level w, @NotNull BlockPos p, @NotNull TagKey<Structure> s) {
        return UtilLib.getStructureStartAt(w, p, s).isPresent();
    }

    public static boolean isInsideStructure(@NotNull Entity entity, @NotNull Structure s) {
        StructureStart start = UtilLib.getStructureStartAt(entity, s);
        return start != null && start.isValid();
    }

    public static boolean isInsideStructure(@NotNull Entity entity, @NotNull TagKey<Structure> structures) {
        return UtilLib.getStructureStartAt(entity, structures).isPresent();
    }

    @Nullable
    public static StructureStart getStructureStartAt(Level level, @NotNull BlockPos pos, @NotNull Structure s) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).isLoaded(pos)) {
            return UtilLib.getStructureStartAt(serverLevel, pos, s);
        }
        return null;
    }

    @NotNull
    public static Optional<StructureStart> getStructureStartAt(Level level, @NotNull BlockPos pos, @NotNull TagKey<Structure> structureTag) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).isLoaded(pos)) {
            Registry registry = serverLevel.registryAccess().registryOrThrow(Registries.STRUCTURE);
            return serverLevel.structureManager().startsForStructure(new ChunkPos(pos), structure -> registry.getHolder(registry.getId(structure)).map(a -> a.is(structureTag)).orElse(false)).stream().findFirst();
        }
        return Optional.empty();
    }

    @NotNull
    public static StructureStart getStructureStartAt(@NotNull ServerLevel w, @NotNull BlockPos pos, @NotNull Structure structure) {
        for (StructureStart structurestart : w.structureManager().startsForStructure(SectionPos.of((BlockPos)pos), structure)) {
            if (!structurestart.getBoundingBox().isInside((Vec3i)pos)) continue;
            return structurestart;
        }
        return StructureStart.INVALID_START;
    }

    public static float[] getColorComponents(int color) {
        int i = (color & 0xFF0000) >> 16;
        int j = (color & 0xFF00) >> 8;
        int k = color & 0xFF;
        return new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
    }

    @NotNull
    public static int[] bbToInt(@NotNull AABB bb) {
        return new int[]{(int)bb.minX, (int)bb.minY, (int)bb.minZ, (int)bb.maxX, (int)bb.maxY, (int)bb.maxZ};
    }

    @NotNull
    public static int[] mbToInt(@NotNull BoundingBox bb) {
        return new int[]{bb.minX(), bb.minY(), bb.minZ(), bb.maxX(), bb.maxY(), bb.maxZ()};
    }

    @NotNull
    public static AABB intToBB(@NotNull @NotNull int @NotNull [] array) {
        return new AABB((double)array[0], (double)array[1], (double)array[2], (double)array[3], (double)array[4], (double)array[5]);
    }

    @NotNull
    public static BoundingBox intToMB(@NotNull @NotNull int @NotNull [] array) {
        return new BoundingBox(array[0], array[1], array[2], array[3], array[4], array[5]);
    }

    @NotNull
    public static BoundingBox AABBtoMB(@NotNull AABB bb) {
        return new BoundingBox((int)bb.minX, (int)bb.minY, (int)bb.minZ, (int)bb.maxX, (int)bb.maxY, (int)bb.maxZ);
    }

    @NotNull
    public static AABB MBtoAABB(@NotNull BoundingBox bb) {
        return new AABB((double)bb.minX(), (double)bb.minY(), (double)bb.minZ(), (double)bb.maxX(), (double)bb.maxY(), (double)bb.maxZ());
    }

    @Nullable
    public static DyeColor getColorForItem(@NotNull Item item) {
        if (!item.builtInRegistryHolder().is(Tags.Items.DYES)) {
            return null;
        }
        Optional<DyeColor> color = Arrays.stream(DyeColor.values()).filter(dye -> item.builtInRegistryHolder().is(dye.getTag())).findFirst();
        if (color.isPresent()) {
            return color.get();
        }
        LOGGER.warn("Could not determine color of {}", (Object)BuiltInRegistries.ITEM.getKey((Object)item));
        return null;
    }

    public static boolean isValidResourceLocation(@NotNull String loc) {
        return ResourceLocation.tryParse((String)loc) != null;
    }

    public static boolean checkRegistryObjectExistence(ResourceKey<? extends Registry<?>> key, Object obj) {
        String string;
        ResourceLocation id;
        if (obj instanceof String && (id = ResourceLocation.tryParse((String)(string = (String)obj))) != null && ServerLifecycleHooks.getCurrentServer() != null) {
            return ServerLifecycleHooks.getCurrentServer().registryAccess().registryOrThrow(key).containsKey(id);
        }
        return false;
    }

    public static void replaceEntity(@NotNull LivingEntity old, @NotNull LivingEntity replacement) {
        Level w = old.getCommandSenderWorld();
        NeoForge.EVENT_BUS.post((Event)new LivingConversionEvent.Post(old, replacement));
        old.remove(Entity.RemovalReason.DISCARDED);
        w.addFreshEntity((Entity)replacement);
    }

    @SafeVarargs
    @NotNull
    public static <T> Set<T> newSortedSet(T ... elements) {
        LinkedHashSet s = new LinkedHashSet();
        Collections.addAll(s, elements);
        return s;
    }

    public static boolean matchesItem(@NotNull Ingredient ingredient, @NotNull ItemStack searchStack) {
        return Arrays.stream(ingredient.getItems()).anyMatch(stack -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)searchStack));
    }

    public static int countItemWithComponent(@NotNull Inventory inventory, @NotNull ItemStack stack) {
        int i = 0;
        for (int j = 0; j < inventory.getContainerSize(); ++j) {
            ItemStack itemstack = inventory.getItem(j);
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack)) continue;
            i += itemstack.getCount();
        }
        return i;
    }

    public static int countItemWithComponent(@NotNull Inventory inventory, @NotNull ItemStack stack, boolean strict) {
        if (strict) {
            return UtilLib.countItemWithComponent(inventory, stack);
        }
        DataComponentPredicate dataComponentPredicate = DataComponentPredicate.allOf((DataComponentMap)stack.getComponents());
        int i = 0;
        for (int j = 0; j < inventory.getContainerSize(); ++j) {
            ItemStack itemstack = inventory.getItem(j);
            if (!ItemStack.isSameItem((ItemStack)itemstack, (ItemStack)stack) || !dataComponentPredicate.test((DataComponentHolder)itemstack)) continue;
            i += itemstack.getCount();
        }
        return i;
    }

    public static void forEachBlockPos(AABB area, Consumer<BlockPos> action) {
        for (double x = area.minX; x <= area.maxX; x += 1.0) {
            for (double y = area.minY; y <= area.maxY; y += 1.0) {
                for (double z = area.minZ; z <= area.maxZ; z += 1.0) {
                    action.accept(new BlockPos((int)x, (int)y, (int)z));
                }
            }
        }
    }

    public static float horizontalDistance(BlockPos pos1, BlockPos pos2) {
        int i = pos2.getX() - pos1.getX();
        int j = pos2.getZ() - pos1.getZ();
        return Mth.sqrt((float)(i * i + j * j));
    }

    public static boolean never(BlockState state, BlockGetter block, BlockPos pos) {
        return false;
    }

    public static boolean always(BlockState state, BlockGetter block, BlockPos pos) {
        return true;
    }

    @Nullable
    public static Direction getDirection(BlockPos origin, BlockPos offset) {
        if (origin.getX() > offset.getX()) {
            return Direction.EAST;
        }
        if (origin.getX() < offset.getX()) {
            return Direction.WEST;
        }
        if (origin.getZ() > offset.getZ()) {
            return Direction.SOUTH;
        }
        if (origin.getZ() < offset.getZ()) {
            return Direction.NORTH;
        }
        if (origin.getY() > offset.getY()) {
            return Direction.UP;
        }
        if (origin.getY() < offset.getY()) {
            return Direction.DOWN;
        }
        return null;
    }

    public static int renderMultiLine(@NotNull Font fontRenderer, @NotNull GuiGraphics graphics, @NotNull Component text, int textLength, int x, int y, int color) {
        int d = 0;
        for (FormattedCharSequence sequence : fontRenderer.split((FormattedText)text, textLength)) {
            graphics.drawString(fontRenderer, sequence, x, y + d, color, false);
            Objects.requireNonNull(fontRenderer);
            d += 9;
        }
        return d;
    }

    public static enum RotationAmount {
        NINETY,
        HUNDRED_EIGHTY,
        TWO_HUNDRED_SEVENTY;

    }
}

