/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.client.gui.screens.radialmenu;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.lib.lib.client.gui.screens.radialmenu.IRadialMenuSlot;
import de.teamlapen.lib.lib.client.gui.screens.radialmenu.RadialMenu;
import de.teamlapen.lib.lib.client.gui.screens.radialmenu.SecondaryIconPosition;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.Input;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

@EventBusSubscriber(value={Dist.CLIENT})
public abstract class GuiRadialMenu<T>
extends Screen {
    private static final float PRECISION = 5.0f;
    protected static final int MAX_SLOTS = 30;
    protected boolean closing;
    private final RadialMenu<T> radialMenu;
    private final boolean allowMouseDirection;
    protected final List<IRadialMenuSlot<T>> radialMenuSlots;
    protected final float OPEN_ANIMATION_LENGTH = 0.2f;
    protected float totalTime;
    protected float prevTick;
    protected float extraTick;
    protected int selectedItem;

    public GuiRadialMenu(RadialMenu<T> radialMenu) {
        this(radialMenu, false);
    }

    public GuiRadialMenu(RadialMenu<T> radialMenu, boolean allowMouseDirection) {
        super((Component)Component.literal((String)""));
        this.radialMenu = radialMenu;
        this.allowMouseDirection = allowMouseDirection;
        this.radialMenuSlots = this.radialMenu.getRadialMenuSlots();
        this.closing = false;
        this.minecraft = Minecraft.getInstance();
        this.selectedItem = -1;
    }

    @SubscribeEvent
    public static void updateInputEvent(MovementInputUpdateEvent event) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof GuiRadialMenu) {
            GuiRadialMenu screen2 = (GuiRadialMenu)screen;
            screen2.processInputEvent(event);
        }
    }

    public void tick() {
        if (this.totalTime != 0.2f) {
            this.extraTick += 1.0f;
        }
    }

    protected boolean isMouseOverMenuItems(double mouseDistanceToCenterOfScreen, float radiusIn, float radiusOut) {
        return this.allowMouseDirection ? mouseDistanceToCenterOfScreen >= 10.0 : mouseDistanceToCenterOfScreen >= (double)radiusIn && mouseDistanceToCenterOfScreen < (double)radiusOut;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int adjusted;
        float sliceBorderRight;
        float sliceBorderLeft;
        int i;
        super.render(graphics, mouseX, mouseY, partialTicks);
        PoseStack pose = graphics.pose();
        float openAnimation = this.closing ? 1.0f - this.totalTime / 0.2f : this.totalTime / 0.2f;
        float currTick = this.minecraft.getTimer().getGameTimeDeltaTicks();
        this.totalTime += (currTick + this.extraTick - this.prevTick) / 20.0f;
        this.extraTick = 0.0f;
        this.prevTick = currTick;
        float animProgress = Mth.clamp((float)openAnimation, (float)0.0f, (float)1.0f);
        animProgress = (float)(1.0 - Math.pow(1.0f - animProgress, 3.0));
        float radiusIn = Math.max(0.1f, 45.0f * animProgress);
        float radiusOut = radiusIn * 2.0f;
        float itemRadius = (radiusIn + radiusOut) * 0.5f;
        int centerOfScreenX = this.width / 2;
        int centerOfScreenY = this.height / 2;
        int numberOfSlices = Math.min(30, this.radialMenuSlots.size());
        double mousePositionInDegreesInRelationToCenterOfScreen = Math.toDegrees(Math.atan2(mouseY - centerOfScreenY, mouseX - centerOfScreenX));
        double mouseDistanceToCenterOfScreen = Math.sqrt(Math.pow(mouseX - centerOfScreenX, 2.0) + Math.pow(mouseY - centerOfScreenY, 2.0));
        float slot0 = (-0.5f / (float)numberOfSlices + 0.25f) * 360.0f;
        if (mousePositionInDegreesInRelationToCenterOfScreen < (double)slot0) {
            mousePositionInDegreesInRelationToCenterOfScreen += 360.0;
        }
        pose.pushPose();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        boolean hasMouseOver = false;
        int mousedOverSlot = -1;
        if (!this.closing) {
            this.selectedItem = -1;
            for (i = 0; i < numberOfSlices; ++i) {
                sliceBorderLeft = (((float)i - 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
                sliceBorderRight = (((float)i + 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
                if (!(mousePositionInDegreesInRelationToCenterOfScreen >= (double)sliceBorderLeft) || !(mousePositionInDegreesInRelationToCenterOfScreen < (double)sliceBorderRight) || !this.isMouseOverMenuItems(mouseDistanceToCenterOfScreen, radiusIn, radiusOut)) continue;
                this.selectedItem = i;
                break;
            }
        }
        for (i = 0; i < numberOfSlices; ++i) {
            sliceBorderLeft = (((float)i - 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
            sliceBorderRight = (((float)i + 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
            IRadialMenuSlot<T> item = this.radialMenuSlots.get((i + numberOfSlices / 2) % numberOfSlices);
            if (this.selectedItem == i) {
                this.drawSlice(item, true, graphics, centerOfScreenX, centerOfScreenY, 10.0f, radiusIn, radiusOut, sliceBorderLeft, sliceBorderRight, 63, 161, 191, 60);
                hasMouseOver = true;
                mousedOverSlot = this.selectedItem;
                continue;
            }
            this.drawSlice(item, false, graphics, centerOfScreenX, centerOfScreenY, 10.0f, radiusIn, radiusOut, sliceBorderLeft, sliceBorderRight, 0, 0, 0, 64);
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (hasMouseOver && mousedOverSlot != -1) {
            adjusted = (mousedOverSlot + (numberOfSlices / 2 + 1)) % numberOfSlices - 1;
            adjusted = adjusted == -1 ? numberOfSlices - 1 : adjusted;
            Component component = this.radialMenuSlots.get(adjusted).slotName();
            pose.translate(0.0f, 0.0f, 50.0f);
            int n = this.width / 2;
            Objects.requireNonNull(this.font);
            graphics.drawCenteredString(this.font, component, n, (this.height - 9) / 2, Optional.ofNullable(component.getStyle().getColor()).map(TextColor::getValue).orElse(0xFFFFFF).intValue());
        }
        pose.pushPose();
        for (i = 0; i < numberOfSlices; ++i) {
            ItemStack stack = new ItemStack((ItemLike)Blocks.DIRT);
            float angle1 = ((float)i / (float)numberOfSlices - 0.25f) * 2.0f * (float)Math.PI;
            if (numberOfSlices % 2 != 0) {
                angle1 += (float)(Math.PI / (double)numberOfSlices);
            }
            float posX = (float)(centerOfScreenX - 8) + itemRadius * (float)Math.cos(angle1);
            float posY = (float)(centerOfScreenY - 8) + itemRadius * (float)Math.sin(angle1);
            RenderSystem.disableDepthTest();
            T primarySlotIcon = this.radialMenuSlots.get(i).primarySlotIcon();
            List<T> secondarySlotIcons = this.radialMenuSlots.get(i).secondarySlotIcons();
            if (primarySlotIcon != null) {
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                this.radialMenu.drawIcon(primarySlotIcon, graphics, (int)posX, (int)posY, 16);
                if (secondarySlotIcons != null && !secondarySlotIcons.isEmpty()) {
                    this.drawSecondaryIcons(graphics, (int)posX, (int)posY, secondarySlotIcons);
                }
            }
            this.drawSliceName(graphics, String.valueOf(i + 1), stack, (int)posX, (int)posY);
        }
        pose.popPose();
        pose.popPose();
        if (mousedOverSlot != -1) {
            adjusted = (mousedOverSlot + (numberOfSlices / 2 + 1)) % numberOfSlices - 1;
            this.selectedItem = adjusted = adjusted == -1 ? numberOfSlices - 1 : adjusted;
        }
    }

    public void drawSecondaryIcons(GuiGraphics graphics, int positionXOfPrimaryIcon, int positionYOfPrimaryIcon, List<T> secondarySlotIcons) {
        if (!this.radialMenu.isShowMoreSecondaryItems()) {
            this.drawSecondaryIcon(graphics, secondarySlotIcons.getFirst(), positionXOfPrimaryIcon, positionYOfPrimaryIcon, this.radialMenu.getSecondaryIconStartingPosition());
        } else {
            SecondaryIconPosition currentSecondaryIconPosition = this.radialMenu.getSecondaryIconStartingPosition();
            for (T secondarySlotIcon : secondarySlotIcons) {
                this.drawSecondaryIcon(graphics, secondarySlotIcon, positionXOfPrimaryIcon, positionYOfPrimaryIcon, currentSecondaryIconPosition);
                currentSecondaryIconPosition = SecondaryIconPosition.getNextPositon(currentSecondaryIconPosition);
            }
        }
    }

    public void drawSecondaryIcon(GuiGraphics graphics, T item, int positionXOfPrimaryIcon, int positionYOfPrimaryIcon, SecondaryIconPosition secondaryIconPosition) {
        int offset = this.radialMenu.getOffset();
        switch (secondaryIconPosition) {
            case NORTH: {
                this.radialMenu.drawIcon(item, graphics, positionXOfPrimaryIcon + offset, positionYOfPrimaryIcon - 14 + offset, 10);
                break;
            }
            case EAST: {
                this.radialMenu.drawIcon(item, graphics, positionXOfPrimaryIcon + 14 + offset, positionYOfPrimaryIcon + offset, 10);
                break;
            }
            case SOUTH: {
                this.radialMenu.drawIcon(item, graphics, positionXOfPrimaryIcon + offset, positionYOfPrimaryIcon + 14 + offset, 10);
                break;
            }
            case WEST: {
                this.radialMenu.drawIcon(item, graphics, positionXOfPrimaryIcon - 14 + offset, positionYOfPrimaryIcon + offset, 10);
            }
        }
    }

    public void drawSliceName(GuiGraphics graphics, String sliceName, ItemStack stack, int posX, int posY) {
        if (!this.radialMenu.isShowMoreSecondaryItems()) {
            graphics.renderItemDecorations(this.font, stack, posX + 5, posY, sliceName);
        } else {
            graphics.renderItemDecorations(this.font, stack, posX + 5, posY + 5, sliceName);
        }
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        int adjustedKey = key - 48;
        if (adjustedKey >= 0 && adjustedKey <= this.radialMenuSlots.size()) {
            this.selectedItem = adjustedKey == 0 ? this.radialMenuSlots.size() : adjustedKey;
            --this.selectedItem;
            this.mouseClicked(0.0, 0.0, 0);
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1) {
            this.onClose();
        } else if (mouseButton == 0 && this.selectedItem != -1) {
            this.radialMenu.setCurrentSlot(this.selectedItem);
            this.minecraft.player.closeContainer();
        }
        return true;
    }

    public void drawSlice(IRadialMenuSlot<T> slot, boolean highlighted, GuiGraphics guiGraphics, float x, float y, float z, float radiusIn, float radiusOut, float startAngle, float endAngle, int r, int g, int b, int a) {
        float angle = endAngle - startAngle;
        int sections = Math.max(1, Mth.ceil((float)(angle / 5.0f)));
        startAngle = (float)Math.toRadians(startAngle);
        endAngle = (float)Math.toRadians(endAngle);
        angle = endAngle - startAngle;
        VertexConsumer buffer = guiGraphics.bufferSource().getBuffer(RenderType.gui());
        for (int i = 0; i < sections; ++i) {
            float angle1 = startAngle + (float)i / (float)sections * angle;
            float angle2 = startAngle + (float)(i + 1) / (float)sections * angle;
            float pos1InX = x + radiusIn * (float)Math.cos(angle1);
            float pos1InY = y + radiusIn * (float)Math.sin(angle1);
            float pos1OutX = x + radiusOut * (float)Math.cos(angle1);
            float pos1OutY = y + radiusOut * (float)Math.sin(angle1);
            float pos2OutX = x + radiusOut * (float)Math.cos(angle2);
            float pos2OutY = y + radiusOut * (float)Math.sin(angle2);
            float pos2InX = x + radiusIn * (float)Math.cos(angle2);
            float pos2InY = y + radiusIn * (float)Math.sin(angle2);
            buffer.addVertex(pos1OutX, pos1OutY, z).setColor(r, g, b, a);
            buffer.addVertex(pos1InX, pos1InY, z).setColor(r, g, b, a);
            buffer.addVertex(pos2InX, pos2InY, z).setColor(r, g, b, a);
            buffer.addVertex(pos2OutX, pos2OutY, z).setColor(r, g, b, a);
        }
        guiGraphics.flush();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void processInputEvent(MovementInputUpdateEvent event) {
        Options settings = Minecraft.getInstance().options;
        Input eInput = event.getInput();
        eInput.up = GuiRadialMenu.isKeyDown0(settings.keyUp);
        eInput.down = GuiRadialMenu.isKeyDown0(settings.keyDown);
        eInput.left = GuiRadialMenu.isKeyDown0(settings.keyLeft);
        eInput.right = GuiRadialMenu.isKeyDown0(settings.keyRight);
        float f = eInput.up == eInput.down ? 0.0f : (eInput.forwardImpulse = eInput.up ? 1.0f : -1.0f);
        eInput.leftImpulse = eInput.left == eInput.right ? 0.0f : (eInput.left ? 1.0f : -1.0f);
        eInput.jumping = GuiRadialMenu.isKeyDown0(settings.keyJump);
        eInput.shiftKeyDown = GuiRadialMenu.isKeyDown0(settings.keyShift);
        if (Minecraft.getInstance().player.isMovingSlowly()) {
            eInput.leftImpulse = (float)((double)eInput.leftImpulse * 0.3);
            eInput.forwardImpulse = (float)((double)eInput.forwardImpulse * 0.3);
        }
    }

    private static boolean isKeyDown0(KeyMapping keybind) {
        if (keybind.isUnbound()) {
            return false;
        }
        return switch (keybind.getKey().getType()) {
            case InputConstants.Type.KEYSYM -> InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keybind.getKey().getValue());
            case InputConstants.Type.MOUSE -> {
                if (GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)keybind.getKey().getValue()) == 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

