/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public final class InventoryUtil {
    private InventoryUtil() {
    }

    public static int getHandSlot(Player player, InteractionHand hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> player.getInventory().selected;
            case InteractionHand.OFF_HAND -> 40;
        };
    }

    public static int getInventorySlotFromCompartment(Player player, int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for empty stack");
        }
        if (player.getInventory().getItem(slot) == stack) {
            return slot;
        }
        if (player.getInventory().getItem(40) == stack) {
            return 40;
        }
        return -1;
    }

    public static @Nullable Container getEntityContainer(ServerLevel level, BlockPos pos, Direction side) {
        Container container;
        EntityHitResult entityHit;
        Entity entity;
        Direction dir;
        Vec3 vecDir;
        Vec3 vecStart = new Vec3((double)pos.getX() + 0.5 + 0.6 * (double)side.getStepX(), (double)pos.getY() + 0.5 + 0.6 * (double)side.getStepY(), (double)pos.getZ() + 0.5 + 0.6 * (double)side.getStepZ());
        HitResult hit = WorldUtil.clip((Level)level, vecStart, vecDir = new Vec3((double)(dir = side.getOpposite()).getStepX(), (double)dir.getStepY(), (double)dir.getStepZ()), 1.1, null);
        return hit instanceof EntityHitResult && (entity = (entityHit = (EntityHitResult)hit).getEntity()) instanceof Container ? (container = (Container)entity) : null;
    }

    public static ItemStack storeItemsIntoSlot(Container container, ItemStack stack, int slot) {
        return InventoryUtil.storeItems(container, stack, slot, 1);
    }

    public static ItemStack storeItemsFromOffset(Container container, ItemStack stack, int offset) {
        return InventoryUtil.storeItems(container, stack, offset, container.getContainerSize());
    }

    private static ItemStack storeItems(Container container, ItemStack stack, int offset, int slotCount) {
        int originalCount = stack.getCount();
        ItemStack remainder = InventoryUtil.storeItemsImpl(container, stack, offset, slotCount);
        if (remainder.getCount() != originalCount) {
            container.setChanged();
        }
        return remainder;
    }

    private static ItemStack storeItemsImpl(Container container, ItemStack stack, int offset, int slotCount) {
        int limit = container.getContainerSize();
        int maxSize = Math.min(stack.getMaxStackSize(), container.getMaxStackSize());
        if (maxSize <= 0) {
            return stack;
        }
        for (int i = 0; i < slotCount; ++i) {
            ItemStack currentStack;
            int slot = i + offset;
            if (slot >= limit) {
                slot -= limit;
            }
            if ((currentStack = container.getItem(slot)).isEmpty()) {
                if (!container.canPlaceItem(slot, stack)) continue;
                if (stack.getCount() <= maxSize) {
                    container.setItem(slot, stack);
                    return ItemStack.EMPTY;
                }
                container.setItem(slot, stack.split(maxSize));
                continue;
            }
            if (currentStack.getCount() >= Math.min(currentStack.getMaxStackSize(), maxSize) || !InventoryUtil.canMergeItems(currentStack, stack)) continue;
            int toMove = Math.min(stack.getCount(), maxSize - currentStack.getCount());
            currentStack.grow(toMove);
            stack.shrink(toMove);
            if (!stack.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return stack;
    }

    private static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        if (stack1.getItem() != stack2.getItem()) {
            return false;
        }
        if (stack1.getDamageValue() != stack2.getDamageValue()) {
            return false;
        }
        if (stack1.getCount() > stack1.getMaxStackSize()) {
            return false;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }
}

