/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.lectern;

import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.container.BasicContainer;
import dan200.computercraft.shared.container.SingleContainerData;
import dan200.computercraft.shared.media.PrintoutMenu;
import dan200.computercraft.shared.media.items.PrintoutData;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.pocket.core.PocketHolder;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import java.util.AbstractList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public final class CustomLecternBlockEntity
extends BlockEntity {
    private static final String NBT_ITEM = "Item";
    private static final String NBT_PAGE = "Page";
    private ItemStack item = ItemStack.EMPTY;
    private int page;
    private int pageCount;

    public CustomLecternBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.BlockEntities.LECTERN.get(), pos, blockState);
    }

    public ItemStack getItem() {
        return this.item;
    }

    void setItem(ItemStack item) {
        this.item = item;
        this.itemChanged();
        BlockEntityHelpers.updateBlock(this);
    }

    int getRedstoneSignal() {
        if (this.item.getItem() instanceof PrintoutItem) {
            float progress = this.pageCount > 1 ? (float)this.page / (float)(this.pageCount - 1) : 1.0f;
            return Mth.floor((float)(progress * 14.0f)) + 1;
        }
        return 15;
    }

    private void itemChanged() {
        if (this.item.getItem() instanceof PrintoutItem) {
            this.pageCount = PrintoutData.getOrEmpty((DataComponentHolder)this.item).pages();
            this.page = Mth.clamp((int)this.page, (int)0, (int)(this.pageCount - 1));
        } else {
            this.page = 0;
            this.pageCount = 0;
        }
    }

    void tick() {
        Item item = this.item.getItem();
        if (item instanceof PocketComputerItem) {
            PocketComputerItem pocket = (PocketComputerItem)item;
            pocket.tick(this.item, new PocketHolder.LecternHolder(this), false);
        }
    }

    private void setPage(int page) {
        if (this.page == page) {
            return;
        }
        this.page = page;
        this.setChanged();
        if (this.getLevel() != null) {
            LecternBlock.signalPageChange((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.item = tag.contains(NBT_ITEM, 10) ? ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(NBT_ITEM)) : ItemStack.EMPTY;
        this.page = tag.getInt(NBT_PAGE);
        this.itemChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.item.isEmpty()) {
            tag.put(NBT_ITEM, this.item.save(registries));
        }
        if (this.item.getItem() instanceof PrintoutItem) {
            tag.putInt(NBT_PAGE, this.page);
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        if (!this.item.isEmpty()) {
            tag.put(NBT_ITEM, this.item.save(registries));
        }
        return tag;
    }

    void openMenu(Player player) {
        ItemStack item = this.getItem();
        if (item.getItem() instanceof PrintoutItem) {
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, inventory, entity) -> new PrintoutMenu(id, new LecternContainer(), 0, p -> Container.stillValidBlockEntity((BlockEntity)this, (Player)p, (float)4.0f), new PrintoutContainerData()), this.getItem().getDisplayName()));
        } else {
            Item item2 = item.getItem();
            if (item2 instanceof PocketComputerItem) {
                PocketComputerItem pocket = (PocketComputerItem)item2;
                pocket.open(player, item, new PocketHolder.LecternHolder(this), true);
            }
        }
    }

    private final class LecternContainer
    implements BasicContainer {
        private final List<ItemStack> itemView = new AbstractList<ItemStack>(){

            @Override
            public ItemStack get(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException("Inventory only has one slot");
                }
                return CustomLecternBlockEntity.this.item;
            }

            @Override
            public int size() {
                return 1;
            }
        };

        private LecternContainer() {
        }

        @Override
        public List<ItemStack> getItems() {
            return this.itemView;
        }

        public void setChanged() {
        }

        public boolean stillValid(Player player) {
            return !CustomLecternBlockEntity.this.isRemoved();
        }
    }

    private final class PrintoutContainerData
    implements SingleContainerData {
        private PrintoutContainerData() {
        }

        @Override
        public int get() {
            return CustomLecternBlockEntity.this.page;
        }

        @Override
        public void set(int index, int value) {
            if (index == 0) {
                CustomLecternBlockEntity.this.setPage(value);
            }
        }
    }
}

