/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import dan200.computercraft.shared.command.UserLevel;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;

public abstract class PermissionRegistry {
    private boolean frozen = false;

    public abstract Predicate<CommandSourceStack> registerCommand(String var1, UserLevel var2);

    protected void checkNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("Permission registry has been frozen.");
        }
    }

    @OverridingMethodsMustInvokeSuper
    public void register() {
        this.frozen = true;
    }

    public static PermissionRegistry create() {
        return ServiceLoader.load(Provider.class).stream().flatMap(x -> ((Provider)x.get()).get().stream()).findFirst().orElseGet(DefaultPermissionRegistry::new);
    }

    public static interface Provider {
        public Optional<PermissionRegistry> get();
    }

    private static final class DefaultPermissionRegistry
    extends PermissionRegistry {
        private DefaultPermissionRegistry() {
        }

        @Override
        public Predicate<CommandSourceStack> registerCommand(String command, UserLevel fallback) {
            this.checkNotFrozen();
            return fallback;
        }
    }
}

