/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.model.turtle;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import dan200.computercraft.client.model.turtle.TurtleModel;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;

public final class TurtleModelLoader
implements IGeometryLoader<Unbaked> {
    private static final ResourceLocation COLOUR_TURTLE_MODEL = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/turtle_colour");
    public static final TurtleModelLoader INSTANCE = new TurtleModelLoader();

    private TurtleModelLoader() {
    }

    public Unbaked read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
        ResourceLocation model = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)modelContents, (String)"model"));
        return new Unbaked(model);
    }

    public static final class Unbaked
    implements IUnbakedGeometry<Unbaked> {
        private final ResourceLocation family;

        private Unbaked(ResourceLocation family) {
            this.family = family;
        }

        public BakedModel bake(IGeometryBakingContext owner, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides) {
            BakedModel mainModel = bakery.bake(this.family, transform, spriteGetter);
            if (mainModel == null) {
                throw new NullPointerException(String.valueOf(this.family) + " failed to bake");
            }
            BakedModel colourModel = bakery.bake(COLOUR_TURTLE_MODEL, transform, spriteGetter);
            if (colourModel == null) {
                throw new NullPointerException(String.valueOf(COLOUR_TURTLE_MODEL) + " failed to bake");
            }
            return new TurtleModel(mainModel, colourModel);
        }
    }
}

