/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import com.mojang.blaze3d.audio.Channel;
import com.mojang.blaze3d.vertex.PoseStack;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.render.CableHighlightRenderer;
import dan200.computercraft.client.render.PocketItemRenderer;
import dan200.computercraft.client.render.PrintoutItemRenderer;
import dan200.computercraft.client.render.monitor.MonitorBlockEntityRenderer;
import dan200.computercraft.client.render.monitor.MonitorHighlightRenderer;
import dan200.computercraft.client.render.monitor.MonitorRenderState;
import dan200.computercraft.client.sound.SpeakerManager;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.CableShapes;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.util.PauseAwareTimer;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jspecify.annotations.Nullable;

public final class ClientHooks {
    private ClientHooks() {
    }

    public static void onTick() {
        FrameInfo.onTick();
    }

    public static void onRenderTick() {
        PauseAwareTimer.tick(Minecraft.getInstance().isPaused());
        FrameInfo.onRenderTick();
    }

    public static void onWorldUnload() {
        MonitorRenderState.destroyAll();
        SpeakerManager.reset();
    }

    public static void onDisconnect() {
        ClientPocketComputers.reset();
    }

    public static boolean drawHighlight(PoseStack transform, MultiBufferSource bufferSource, Camera camera, BlockHitResult hit) {
        return CableHighlightRenderer.drawHighlight(transform, bufferSource, camera, hit) || MonitorHighlightRenderer.drawHighlight(transform, bufferSource, camera, hit);
    }

    public static boolean onRenderHeldItem(PoseStack transform, MultiBufferSource render, int lightTexture, InteractionHand hand, float pitch, float equipProgress, float swingProgress, ItemStack stack) {
        if (stack.getItem() instanceof PocketComputerItem) {
            PocketItemRenderer.INSTANCE.renderItemFirstPerson(transform, render, lightTexture, hand, pitch, equipProgress, swingProgress, stack);
            return true;
        }
        if (stack.getItem() instanceof PrintoutItem) {
            PrintoutItemRenderer.INSTANCE.renderItemFirstPerson(transform, render, lightTexture, hand, pitch, equipProgress, swingProgress, stack);
            return true;
        }
        return false;
    }

    public static boolean onRenderItemFrame(PoseStack transform, MultiBufferSource render, ItemFrame frame, ItemStack stack, int light) {
        if (stack.getItem() instanceof PrintoutItem) {
            PrintoutItemRenderer.onRenderInFrame(transform, render, frame, stack, light);
            return true;
        }
        return false;
    }

    public static void onPlayStreaming(SoundEngine engine, Channel channel, AudioStream stream) {
        SpeakerManager.onPlayStreaming(engine, channel, stream);
    }

    public static void addBlockDebugInfo(Consumer<String> addText) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.getDebugOverlay().showDebugScreen() || minecraft.level == null) {
            return;
        }
        if (minecraft.hitResult == null || minecraft.hitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockEntity tile = minecraft.level.getBlockEntity(((BlockHitResult)minecraft.hitResult).getBlockPos());
        if (tile instanceof MonitorBlockEntity) {
            MonitorBlockEntity monitor = (MonitorBlockEntity)tile;
            addText.accept("");
            addText.accept(String.format("Targeted monitor: (%d, %d), %d x %d", monitor.getXIndex(), monitor.getYIndex(), monitor.getWidth(), monitor.getHeight()));
        } else if (tile instanceof TurtleBlockEntity) {
            TurtleBlockEntity turtle = (TurtleBlockEntity)tile;
            addText.accept("");
            addText.accept("Targeted turtle:");
            addText.accept(String.format("Id: %d", turtle.getComputerID()));
            ClientHooks.addTurtleUpgrade(addText, turtle, TurtleSide.LEFT);
            ClientHooks.addTurtleUpgrade(addText, turtle, TurtleSide.RIGHT);
        }
    }

    private static void addTurtleUpgrade(Consumer<String> out, TurtleBlockEntity turtle, TurtleSide side) {
        UpgradeData<ITurtleUpgrade> upgrade = turtle.getAccess().getUpgradeWithData(side);
        if (upgrade != null) {
            out.accept(String.format("Upgrade[%s]: %s", new Object[]{side, upgrade.holder().key().location()}));
        }
    }

    public static void addGameDebugInfo(Consumer<String> addText) {
        if (MonitorBlockEntityRenderer.hasRenderedThisFrame() && Minecraft.getInstance().getDebugOverlay().showDebugScreen()) {
            addText.accept("[CC:T] Monitor renderer: " + String.valueOf((Object)MonitorBlockEntityRenderer.currentRenderer()));
        }
    }

    public static @Nullable BlockState getBlockBreakingState(BlockState state, BlockPos pos) {
        if (state.getBlock() != ModRegistry.Blocks.CABLE.get() || !((Boolean)state.getValue((Property)CableBlock.CABLE)).booleanValue() || state.getValue(CableBlock.MODEM) == CableModemVariant.None) {
            return null;
        }
        HitResult hit = Minecraft.getInstance().hitResult;
        if (hit == null || hit.getType() != HitResult.Type.BLOCK) {
            return null;
        }
        BlockPos hitPos = ((BlockHitResult)hit).getBlockPos();
        if (!hitPos.equals((Object)pos)) {
            return null;
        }
        return WorldUtil.isVecInside(CableShapes.getModemShape(state), hit.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())) ? (BlockState)state.getBlock().defaultBlockState().setValue(CableBlock.MODEM, (Comparable)((Object)((CableModemVariant)((Object)state.getValue(CableBlock.MODEM))))) : (BlockState)state.setValue(CableBlock.MODEM, (Comparable)((Object)CableModemVariant.None));
    }
}

