/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.screen;

import io.github.mortuusars.scholar.Config;
import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.ScholarClient;
import io.github.mortuusars.scholar.client.gui.Widgets;
import io.github.mortuusars.scholar.client.gui.widget.textbox.TextBox;
import io.github.mortuusars.scholar.client.util.RenderUtil;
import java.util.Objects;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public abstract class SpreadBookScreen
extends Screen {
    public static final ResourceLocation TEXTURE = Scholar.resource("textures/gui/book.png");
    public static final int BOOK_WIDTH = 295;
    public static final int BOOK_HEIGHT = 180;
    public static final int TEXT_LEFT_X = 22;
    public static final int TEXT_RIGHT_X = 159;
    public static final int TEXT_Y = 21;
    public static final int TEXT_WIDTH = 114;
    public static final int TEXT_HEIGHT = 128;
    @NotNull
    protected final Minecraft minecraft = Minecraft.getInstance();
    @NotNull
    protected final LocalPlayer player;
    protected int bookColor;
    protected int textColor;
    protected int pageNumbersColor;
    protected int selectionColor;
    protected int selectionUnfocusedColor;
    protected int leftPos;
    protected int topPos;
    protected Button prevPageButton;
    protected Button nextPageButton;
    protected int currentSpread;

    public SpreadBookScreen(int bookColor) {
        super(GameNarrator.NO_TITLE);
        this.player = Objects.requireNonNull(this.minecraft.player);
        this.bookColor = bookColor;
        this.textColor = Config.Client.getColor(Config.Client.TEXT_COLOR);
        this.pageNumbersColor = Config.Client.getColor(Config.Client.PAGE_NUMBERS_COLOR);
        this.selectionColor = Config.Client.getColor(Config.Client.SELECTION_COLOR);
        this.selectionUnfocusedColor = Config.Client.getColor(Config.Client.SELECTION_UNFOCUSED_COLOR);
    }

    public boolean isPauseScreen() {
        return (Boolean)Config.Client.SCREEN_PAUSE.get();
    }

    protected void init() {
        this.leftPos = (this.width - 295) / 2;
        this.topPos = (this.height - 180) / 2;
        this.createWidgets();
    }

    protected void createWidgets() {
        this.createPrevPageButton();
        this.createNextPageButton();
        this.createBottomButtons();
    }

    protected void createPrevPageButton() {
        ImageButton prevPageButton = new ImageButton(this.leftPos + 12, this.topPos + 156, 13, 15, Widgets.PREVIOUS_PAGE_SPRITES, button -> this.pageBack());
        prevPageButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"spectatorMenu.previous_page")));
        this.prevPageButton = (Button)this.addRenderableWidget((GuiEventListener)prevPageButton);
    }

    protected void createNextPageButton() {
        ImageButton nextPageButton = new ImageButton(this.leftPos + 270, this.topPos + 156, 13, 15, Widgets.NEXT_PAGE_SPRITES, button -> this.pageForward());
        nextPageButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"spectatorMenu.next_page")));
        this.nextPageButton = (Button)this.addRenderableWidget((GuiEventListener)nextPageButton);
    }

    protected void createBottomButtons() {
        if (((Boolean)Config.Client.SHOW_DONE_BUTTON.get()).booleanValue()) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2 - 60, this.topPos + 180 + 12, 120, 20).build());
        }
    }

    protected void updateButtonVisibility() {
        this.prevPageButton.visible = this.currentSpread > 0;
        this.nextPageButton.visible = this.currentSpread < this.getSpreadCount() - 1;
    }

    protected void toggleBookTools() {
        boolean currentValue = (Boolean)Config.Client.EDIT_SCREEN_SHOW_EXTRA_TOOLS.get();
        Config.Client.EDIT_SCREEN_SHOW_EXTRA_TOOLS.set((Object)(!currentValue ? 1 : 0));
        Config.Client.EDIT_SCREEN_SHOW_EXTRA_TOOLS.save();
    }

    public boolean isToolsVisible() {
        return (Boolean)Config.Client.EDIT_SCREEN_SHOW_EXTRA_TOOLS.get();
    }

    public int getPageCount() {
        return 100;
    }

    public int getSpreadCount() {
        return (int)Math.ceil((double)this.getPageCount() / 2.0);
    }

    protected boolean pageBack() {
        if (this.currentSpread > 0) {
            --this.currentSpread;
            this.playPageTurnSound(0.8f);
            return true;
        }
        return false;
    }

    protected boolean pageForward() {
        if (this.currentSpread < this.getSpreadCount() - 1) {
            ++this.currentSpread;
            this.playPageTurnSound(1.0f);
            return true;
        }
        return false;
    }

    protected void renderBook(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtil.withColorMultiplied(this.bookColor, () -> guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 295, 180, 0.0f, 0.0f, 295, 180, 512, 512));
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 295, 180, 0.0f, 180.0f, 295, 180, 512, 512);
    }

    protected void renderPageNumbers(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int currentSpread) {
        this.renderLeftPageNumber(guiGraphics, mouseX, mouseY, partialTick, currentSpread, this.pageNumbersColor);
        this.renderRightPageNumber(guiGraphics, mouseX, mouseY, partialTick, currentSpread, this.pageNumbersColor);
    }

    protected void renderLeftPageNumber(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int currentSpread, int color) {
        String leftPageNumber = Integer.toString(currentSpread * 2 + 1);
        guiGraphics.drawString(this.font, leftPageNumber, this.leftPos + 69 + (8 - this.font.width(leftPageNumber) / 2), this.topPos + 157, color, false);
    }

    protected void renderRightPageNumber(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int currentSpread, int color) {
        String rightPageNumber = Integer.toString(currentSpread * 2 + 2);
        guiGraphics.drawString(this.font, rightPageNumber, this.leftPos + 208 + (8 - this.font.width(rightPageNumber) / 2), this.topPos + 157, color, false);
    }

    protected void renderTools(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (ScholarClient.KeyMappings.toggleBookTools.matches(keyCode, scanCode)) {
            this.toggleBookTools();
            return true;
        }
        if (!(this.getFocused() instanceof TextBox)) {
            if (Minecraft.getInstance().options.keyInventory.matches(keyCode, scanCode)) {
                this.onClose();
                return true;
            }
            if (keyCode == 263 || keyCode == 266 || Minecraft.getInstance().options.keyLeft.matches(keyCode, scanCode)) {
                this.pageBack();
                return true;
            }
            if (keyCode == 262 || keyCode == 267 || Minecraft.getInstance().options.keyRight.matches(keyCode, scanCode)) {
                this.pageForward();
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return (mouseX -= (double)this.leftPos) >= (double)(x - 1) && mouseX < (double)(x + width + 1) && (mouseY -= (double)this.topPos) >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    protected boolean isHoveringOverRightPageNumber(double mouseX, double mouseY) {
        return this.isHovering(206, 157, 17, 7, mouseX, mouseY);
    }

    protected boolean isHoveringOverLeftPageNumber(double mouseX, double mouseY) {
        return this.isHovering(66, 157, 17, 7, mouseX, mouseY);
    }

    protected boolean isLeftPage(int pageIndex) {
        return pageIndex % 2 == 0;
    }

    protected boolean isRightPage(int pageIndex) {
        return pageIndex % 2 == 1;
    }

    protected void playButtonClickSound(float volume, float pitch) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)pitch, (float)volume));
    }

    protected void playButtonClickSound(float pitch) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)pitch, (float)0.3f));
    }

    protected void playButtonClickSound() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f, (float)0.3f));
    }

    protected void playPageTurnSound(float volume, float pitch) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)pitch, (float)volume));
    }

    protected void playPageTurnSound(float pitch) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)pitch, (float)1.0f));
    }

    protected void playPageTurnSound() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f, (float)1.0f));
    }
}

