/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.gettingstarted.exaltation;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.NiterRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class DigestionEntry
extends EntryProvider {
    public static final String ENTRY_ID = "digestion_exaltation";

    public DigestionEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Digestion");
        this.pageText("The key process of Exaltation is the Digestion of lower Niter into higher Niter (or vice versa).\n\\\n\\\nWe need 4 {0} to create 1 {1}.\n", new Object[]{this.itemLink("Alchemical Niter: Common Metals", (ItemLike)NiterRegistry.METALS_COMMON.get()), this.itemLink("Alchemical Niter: Rare Metals", (ItemLike)NiterRegistry.METALS_RARE.get())});
        this.page("metals", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)NiterRegistry.METALS_RARE.get()})).withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Alchemical Niter: Rare Metals");
        this.pageText("[#]($INPUT)Right-click[#]() the {0} with the ingredients to place them inside:\n- 4x {1}\n- {2}\n- {3}\n\n_Gold is not needed for \"downgrade\", only for \"upgrade\"._\n\\\n(Check JEI for more recipes)\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.DIGESTION_VAT.get()), this.itemLink("Alchemical Niter: Common Metals", (ItemLike)NiterRegistry.METALS_COMMON.get()), this.itemLink((ItemLike)ItemRegistry.SAL_AMMONIAC_BUCKET.get()), this.itemLink((ItemLike)ItemRegistry.PURIFIED_GOLD.get())});
        this.page("start", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Process");
        this.pageText("[#]($INPUT)Shift-right-click[#]() the {0} with an [#]($INPUT)empty hand[#]() to close the vat and start the digestion.\n\\\n\\\nOnce it opens again the process is complete.\n\\\n\\\n[#]($INPUT)Right-click[#]() with an empty hand to retrieve the {1}.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.DIGESTION_VAT.get()), this.itemLink("Alchemical Niter: Rare Metals", (ItemLike)NiterRegistry.METALS_RARE.get())});
        this.page("bulk", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Bulk Processing");
        this.pageText("You can provide all these ingredients in bulk, the process will then repeat until all ingredients are consumed.\n\\\n\\\nYou can also [#]($INPUT)shift-right-click[#]() with an [#]($INPUT)empty hand[#]() to open the vat and interrupt processing to take out the intermediate result.\n");
        this.page("bulk2", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Bulk Processing");
        this.pageText("Remember: the more Rare Metals Niter you produce from Common Metals Niter (via Iron Sulfur) the more Gold you can get in the end.\n");
    }

    protected String entryName() {
        return "Digestion";
    }

    protected String entryDescription() {
        return "Convert Common Metals Niter into Rare Metals Niter";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)((ItemLike)NiterRegistry.METALS_RARE.get()));
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

