/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.storage;

import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class MonitoredItemStackHandler
extends ItemStackHandler {
    public MonitoredItemStackHandler() {
    }

    public MonitoredItemStackHandler(int size) {
        super(size);
    }

    public MonitoredItemStackHandler(NonNullList<ItemStack> stacks) {
        super(stacks);
    }

    protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
    }

    protected void onSetStackInSlot(int slot, ItemStack oldStack, ItemStack newStack, boolean isSameItem) {
    }

    protected void onInsertItem(int slot, ItemStack oldStack, ItemStack newStack, ItemStack toInsert, ItemStack remainingInSource) {
    }

    protected void onExtractItem(int slot, ItemStack oldStack, ItemStack newStack, ItemStack extracted) {
    }

    public void setStackInSlot(int slot, @NotNull ItemStack newStack) {
        ItemStack oldStack = this.getStackInSlot(slot).copy();
        boolean sameItem = ItemStack.isSameItemSameComponents((ItemStack)newStack, (ItemStack)oldStack);
        super.setStackInSlot(slot, newStack);
        this.onSetStackInSlot(slot, oldStack, newStack, sameItem);
        if (!sameItem) {
            this.onContentTypeChanged(slot, oldStack, newStack);
        }
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack toInsert, boolean simulate) {
        if (!simulate) {
            ItemStack oldStack = this.getStackInSlot(slot).copy();
            ItemStack remaining = super.insertItem(slot, toInsert, simulate);
            ItemStack newStack = this.getStackInSlot(slot);
            this.onInsertItem(slot, oldStack, newStack, toInsert, remaining);
            if (remaining != toInsert) {
                this.onContentTypeChanged(slot, oldStack, newStack);
            }
            return remaining;
        }
        return super.insertItem(slot, toInsert, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!simulate) {
            ItemStack oldStack = this.getStackInSlot(slot).copy();
            ItemStack extracted = super.extractItem(slot, amount, simulate);
            ItemStack newStack = this.getStackInSlot(slot);
            this.onExtractItem(slot, oldStack, newStack, extracted);
            if (oldStack.isEmpty() != newStack.isEmpty()) {
                this.onContentTypeChanged(slot, oldStack, newStack);
            }
            return extracted;
        }
        return super.extractItem(slot, amount, simulate);
    }
}

