/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.redstone;

import com.klikli_dev.theurgy.content.behaviour.storage.HasStorageBehaviour;
import com.klikli_dev.theurgy.content.behaviour.storage.OutputStorageBehaviour;
import com.klikli_dev.theurgy.content.behaviour.storage.StorageBehaviour;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;

public class VatAnalogSignalOutputBehaviour {
    public static int getRedstoneSignalFromContainer(@Nullable IItemHandler pContainer) {
        if (pContainer == null) {
            return 0;
        }
        float f = 0.0f;
        for (int i = 0; i < pContainer.getSlots(); ++i) {
            ItemStack itemstack = pContainer.getStackInSlot(i);
            if (itemstack.isEmpty()) continue;
            f += (float)itemstack.getCount() / (float)Math.min(pContainer.getSlotLimit(i), itemstack.getMaxStackSize());
        }
        return Mth.lerpDiscrete((float)(f /= (float)pContainer.getSlots()), (int)0, (int)15);
    }

    public int getAnalogOutputSignal(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (!(blockEntity instanceof HasStorageBehaviour)) {
            return 0;
        }
        HasStorageBehaviour hasStorageBehaviour = (HasStorageBehaviour)blockEntity;
        StorageBehaviour storageBehaviour = hasStorageBehaviour.storageBehaviour();
        if (!(storageBehaviour instanceof OutputStorageBehaviour)) {
            return 0;
        }
        OutputStorageBehaviour outputStorageBehaviour = (OutputStorageBehaviour)((Object)storageBehaviour);
        return VatAnalogSignalOutputBehaviour.getRedstoneSignalFromContainer(outputStorageBehaviour.outputInventory());
    }
}

