/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.salammoniacaccumulator.render;

import com.klikli_dev.theurgy.content.apparatus.salammoniacaccumulator.SalAmmoniacAccumulatorBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.salammoniacaccumulator.render.SalAmmoniacAccumulatorModel;
import com.klikli_dev.theurgy.content.render.FluidRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class SalAmmoniacAccumulatorRenderer
extends GeoBlockRenderer<SalAmmoniacAccumulatorBlockEntity> {
    public SalAmmoniacAccumulatorRenderer(BlockEntityRendererProvider.Context pContext) {
        super((GeoModel)new SalAmmoniacAccumulatorModel());
    }

    public void postRender(PoseStack poseStack, SalAmmoniacAccumulatorBlockEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.postRender(poseStack, (GeoAnimatable)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        if (animatable.waterTank.isEmpty()) {
            return;
        }
        FluidStack fluidStack = animatable.waterTank.getFluid();
        float fluidHeight = (float)fluidStack.getAmount() / (float)animatable.waterTank.getCapacity();
        float blockHeight = 0.734375f;
        float blockWidth = 1.0f;
        float capHeight = 0.0f;
        float tankHullWidth = 0.203125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = blockHeight - 2.0f * capHeight - minPuddleHeight;
        float level = fluidHeight;
        float clampedLevel = Mth.clamp((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        float xMin = tankHullWidth;
        float xMax = xMin + blockWidth - 2.0f * tankHullWidth;
        float yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
        float yMax = yMin + clampedLevel;
        float zMin = tankHullWidth;
        float zMax = zMin + blockWidth - 2.0f * tankHullWidth;
        poseStack.pushPose();
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        poseStack.translate(0.0f, clampedLevel - totalHeight, 0.0f);
        FluidRenderer.renderFluidBox(fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, bufferSource, poseStack, packedLight, false);
        poseStack.popPose();
    }
}

