/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.reformationarray;

import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterBlockEntity;
import com.klikli_dev.theurgy.content.particle.ParticleColor;
import com.klikli_dev.theurgy.content.particle.glow.GlowParticleProvider;
import com.klikli_dev.theurgy.content.storage.MonitoredItemStackHandler;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ReformationSourcePedestalBlockEntity
extends BlockEntity {
    public ItemStackHandler inputInventory = new InputInventory();
    public WeakReference<SulfuricFluxEmitterBlockEntity> sulfuricFluxEmitter;
    protected boolean showParticles;

    public ReformationSourcePedestalBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityRegistry.REFORMATION_SOURCE_PEDESTAL.get(), pPos, pBlockState);
    }

    public void setSulfuricFluxEmitter(SulfuricFluxEmitterBlockEntity sulfuricFluxEmitter) {
        this.sulfuricFluxEmitter = new WeakReference<SulfuricFluxEmitterBlockEntity>(sulfuricFluxEmitter);
    }

    public void tickClient() {
        if (this.showParticles && this.level.getRandom().nextFloat() < 0.07f) {
            BlockPos pos = this.getBlockPos();
            this.level.addParticle(GlowParticleProvider.createOptions(ParticleColor.fromInt(0xFF00FF), 0.5f, 0.75f, 200), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.0f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
        }
    }

    public void setRemoved() {
        if (this.sulfuricFluxEmitter != null && this.sulfuricFluxEmitter.get() != null) {
            ((SulfuricFluxEmitterBlockEntity)((Object)this.sulfuricFluxEmitter.get())).removeSourcePedestal(this);
            this.sulfuricFluxEmitter.clear();
        }
        super.setRemoved();
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        this.writeNetwork(pTag, pRegistries);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.readNetwork(pTag, pRegistries);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        this.writeNetwork(tag, pRegistries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider pRegistries) {
        this.readNetwork(tag, pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider pRegistries) {
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.readNetwork(tag, pRegistries);
        }
    }

    public void readNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        if (pTag.contains("showParticles")) {
            this.showParticles = pTag.getBoolean("showParticles");
        }
        if (pTag.contains("inputInventory")) {
            this.inputInventory.deserializeNBT(pRegistries, pTag.getCompound("inputInventory"));
        }
    }

    public void writeNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.showParticles = !this.inputInventory.getStackInSlot(0).isEmpty();
        pTag.putBoolean("showParticles", this.showParticles);
        pTag.put("inputInventory", (Tag)this.inputInventory.serializeNBT(pRegistries));
    }

    public void sendBlockUpdated() {
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public class InputInventory
    extends MonitoredItemStackHandler {
        public InputInventory() {
            super(1);
        }

        protected SulfuricFluxEmitterBlockEntity emitter() {
            WeakReference<SulfuricFluxEmitterBlockEntity> emitter = ReformationSourcePedestalBlockEntity.this.sulfuricFluxEmitter;
            return emitter != null ? (SulfuricFluxEmitterBlockEntity)((Object)emitter.get()) : null;
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            ReformationSourcePedestalBlockEntity.this.sendBlockUpdated();
            if (this.emitter() != null) {
                this.emitter().craftingBehaviour.onInputItemChanged(oldStack, newStack);
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.is(ItemTagRegistry.ALCHEMICAL_SULFURS_AND_NITERS) && super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            ReformationSourcePedestalBlockEntity.this.setChanged();
            if (this.emitter() != null) {
                this.emitter().onSourcePedestalContentChange(ReformationSourcePedestalBlockEntity.this);
            }
        }
    }
}

